/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.apache.http.client.protocol;

import com.mathworks.apache.commons.logging.Log;
import com.mathworks.apache.commons.logging.LogFactory;
import com.mathworks.apache.http.Header;
import com.mathworks.apache.http.HttpException;
import com.mathworks.apache.http.HttpHost;
import com.mathworks.apache.http.HttpRequest;
import com.mathworks.apache.http.HttpRequestInterceptor;
import com.mathworks.apache.http.ProtocolException;
import com.mathworks.apache.http.annotation.Immutable;
import com.mathworks.apache.http.client.CookieStore;
import com.mathworks.apache.http.client.methods.HttpUriRequest;
import com.mathworks.apache.http.client.params.HttpClientParams;
import com.mathworks.apache.http.conn.HttpRoutedConnection;
import com.mathworks.apache.http.conn.routing.HttpRoute;
import com.mathworks.apache.http.cookie.Cookie;
import com.mathworks.apache.http.cookie.CookieOrigin;
import com.mathworks.apache.http.cookie.CookieSpec;
import com.mathworks.apache.http.cookie.CookieSpecRegistry;
import com.mathworks.apache.http.cookie.SetCookie2;
import com.mathworks.apache.http.protocol.HttpContext;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Immutable
public class RequestAddCookies
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        int ver;
        URI requestURI;
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        CookieStore cookieStore = (CookieStore)context.getAttribute("http.cookie-store");
        if (cookieStore == null) {
            this.log.debug("Cookie store not specified in HTTP context");
            return;
        }
        CookieSpecRegistry registry = (CookieSpecRegistry)context.getAttribute("http.cookiespec-registry");
        if (registry == null) {
            this.log.debug("CookieSpec registry not specified in HTTP context");
            return;
        }
        HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
        if (targetHost == null) {
            this.log.debug("Target host not set in the context");
            return;
        }
        HttpRoutedConnection conn = (HttpRoutedConnection)context.getAttribute("http.connection");
        if (conn == null) {
            this.log.debug("HTTP connection not set in the context");
            return;
        }
        String policy = HttpClientParams.getCookiePolicy(request.getParams());
        if (this.log.isDebugEnabled()) {
            this.log.debug("CookieSpec selected: " + policy);
        }
        if (request instanceof HttpUriRequest) {
            requestURI = ((HttpUriRequest)request).getURI();
        } else {
            try {
                requestURI = new URI(request.getRequestLine().getUri());
            }
            catch (URISyntaxException ex) {
                throw new ProtocolException("Invalid request URI: " + request.getRequestLine().getUri(), ex);
            }
        }
        String hostName = targetHost.getHostName();
        int port = targetHost.getPort();
        if (port < 0) {
            String scheme;
            HttpRoute route = conn.getRoute();
            port = route.getHopCount() == 1 ? conn.getRemotePort() : ((scheme = targetHost.getSchemeName()).equalsIgnoreCase("http") ? 80 : (scheme.equalsIgnoreCase("https") ? 443 : 0));
        }
        CookieOrigin cookieOrigin = new CookieOrigin(hostName, port, requestURI.getPath(), conn.isSecure());
        CookieSpec cookieSpec = registry.getCookieSpec(policy, request.getParams());
        ArrayList<Cookie> cookies = new ArrayList<Cookie>(cookieStore.getCookies());
        ArrayList<Cookie> matchedCookies = new ArrayList<Cookie>();
        Date now = new Date();
        for (Cookie cookie : cookies) {
            if (!cookie.isExpired(now)) {
                if (!cookieSpec.match(cookie, cookieOrigin)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Cookie " + cookie + " match " + cookieOrigin);
                }
                matchedCookies.add(cookie);
                continue;
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("Cookie " + cookie + " expired");
        }
        if (!matchedCookies.isEmpty()) {
            List<Header> headers = cookieSpec.formatCookies(matchedCookies);
            for (Header header : headers) {
                request.addHeader(header);
            }
        }
        if ((ver = cookieSpec.getVersion()) > 0) {
            Header header;
            boolean needVersionHeader = false;
            for (Cookie cookie : matchedCookies) {
                if (ver == cookie.getVersion() && cookie instanceof SetCookie2) continue;
                needVersionHeader = true;
            }
            if (needVersionHeader && (header = cookieSpec.getVersionHeader()) != null) {
                request.addHeader(header);
            }
        }
        context.setAttribute("http.cookie-spec", cookieSpec);
        context.setAttribute("http.cookie-origin", cookieOrigin);
    }
}

