/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.apache.http.client.protocol;

import com.mathworks.apache.http.HttpException;
import com.mathworks.apache.http.HttpRequest;
import com.mathworks.apache.http.annotation.Immutable;
import com.mathworks.apache.http.auth.AuthState;
import com.mathworks.apache.http.client.protocol.RequestAuthenticationBase;
import com.mathworks.apache.http.protocol.HttpContext;
import java.io.IOException;

@Immutable
public class RequestTargetAuthentication
extends RequestAuthenticationBase {
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        if (request.containsHeader("Authorization")) {
            return;
        }
        AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
        if (authState == null) {
            this.log.debug("Target auth state not set in the context");
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Target auth state: " + (Object)((Object)authState.getState()));
        }
        this.process(authState, request, context);
    }
}

