/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.apache.http.client.protocol;

import com.mathworks.apache.http.Header;
import com.mathworks.apache.http.HeaderElement;
import com.mathworks.apache.http.HttpEntity;
import com.mathworks.apache.http.HttpException;
import com.mathworks.apache.http.HttpResponse;
import com.mathworks.apache.http.HttpResponseInterceptor;
import com.mathworks.apache.http.annotation.Immutable;
import com.mathworks.apache.http.client.entity.DeflateDecompressingEntity;
import com.mathworks.apache.http.client.entity.GzipDecompressingEntity;
import com.mathworks.apache.http.protocol.HttpContext;
import java.io.IOException;
import java.util.Locale;

@Immutable
public class ResponseContentEncoding
implements HttpResponseInterceptor {
    public static final String UNCOMPRESSED = "http.client.response.uncompressed";

    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        HeaderElement[] codecs;
        HeaderElement[] arr$;
        int len$;
        int i$;
        Header ceheader;
        HttpEntity entity = response.getEntity();
        if (entity != null && (ceheader = entity.getContentEncoding()) != null && (i$ = 0) < (len$ = (arr$ = (codecs = ceheader.getElements())).length)) {
            HeaderElement codec = arr$[i$];
            String codecname = codec.getName().toLowerCase(Locale.US);
            if ("gzip".equals(codecname) || "x-gzip".equals(codecname)) {
                response.setEntity(new GzipDecompressingEntity(response.getEntity()));
                if (context != null) {
                    context.setAttribute(UNCOMPRESSED, true);
                }
                return;
            }
            if ("deflate".equals(codecname)) {
                response.setEntity(new DeflateDecompressingEntity(response.getEntity()));
                if (context != null) {
                    context.setAttribute(UNCOMPRESSED, true);
                }
                return;
            }
            if ("identity".equals(codecname)) {
                return;
            }
            throw new HttpException("Unsupported Content-Coding: " + codec.getName());
        }
    }
}

