/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.apache.http.conn;

import com.mathworks.apache.http.HttpEntity;
import com.mathworks.apache.http.annotation.NotThreadSafe;
import com.mathworks.apache.http.conn.ConnectionReleaseTrigger;
import com.mathworks.apache.http.conn.EofSensorInputStream;
import com.mathworks.apache.http.conn.EofSensorWatcher;
import com.mathworks.apache.http.conn.ManagedClientConnection;
import com.mathworks.apache.http.entity.HttpEntityWrapper;
import com.mathworks.apache.http.util.EntityUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;

@NotThreadSafe
public class BasicManagedEntity
extends HttpEntityWrapper
implements ConnectionReleaseTrigger,
EofSensorWatcher {
    protected ManagedClientConnection managedConn;
    protected final boolean attemptReuse;

    public BasicManagedEntity(HttpEntity entity, ManagedClientConnection conn, boolean reuse) {
        super(entity);
        if (conn == null) {
            throw new IllegalArgumentException("Connection may not be null.");
        }
        this.managedConn = conn;
        this.attemptReuse = reuse;
    }

    public boolean isRepeatable() {
        return false;
    }

    public InputStream getContent() throws IOException {
        return new EofSensorInputStream(this.wrappedEntity.getContent(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureConsumed() throws IOException {
        if (this.managedConn == null) {
            return;
        }
        try {
            if (this.attemptReuse) {
                EntityUtils.consume(this.wrappedEntity);
                this.managedConn.markReusable();
            }
        }
        finally {
            this.releaseManagedConnection();
        }
    }

    public void consumeContent() throws IOException {
        this.ensureConsumed();
    }

    public void writeTo(OutputStream outstream) throws IOException {
        super.writeTo(outstream);
        this.ensureConsumed();
    }

    public void releaseConnection() throws IOException {
        this.ensureConsumed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortConnection() throws IOException {
        if (this.managedConn != null) {
            try {
                this.managedConn.abortConnection();
            }
            finally {
                this.managedConn = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean eofDetected(InputStream wrapped) throws IOException {
        try {
            if (this.attemptReuse && this.managedConn != null) {
                wrapped.close();
                this.managedConn.markReusable();
            }
        }
        finally {
            this.releaseManagedConnection();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean streamClosed(InputStream wrapped) throws IOException {
        block6: {
            try {
                if (!this.attemptReuse || this.managedConn == null) break block6;
                boolean valid = this.managedConn.isOpen();
                try {
                    wrapped.close();
                    this.managedConn.markReusable();
                }
                catch (SocketException ex) {
                    if (valid) {
                        throw ex;
                    }
                }
            }
            finally {
                this.releaseManagedConnection();
            }
        }
        return false;
    }

    public boolean streamAbort(InputStream wrapped) throws IOException {
        if (this.managedConn != null) {
            this.managedConn.abortConnection();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseManagedConnection() throws IOException {
        if (this.managedConn != null) {
            try {
                this.managedConn.releaseConnection();
            }
            finally {
                this.managedConn = null;
            }
        }
    }
}

