/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.apache.http.impl.auth;

import com.mathworks.apache.commons.codec.binary.Base64;
import com.mathworks.apache.http.Header;
import com.mathworks.apache.http.HttpRequest;
import com.mathworks.apache.http.annotation.NotThreadSafe;
import com.mathworks.apache.http.auth.AuthenticationException;
import com.mathworks.apache.http.auth.ChallengeState;
import com.mathworks.apache.http.auth.Credentials;
import com.mathworks.apache.http.auth.MalformedChallengeException;
import com.mathworks.apache.http.auth.params.AuthParams;
import com.mathworks.apache.http.impl.auth.RFC2617Scheme;
import com.mathworks.apache.http.message.BufferedHeader;
import com.mathworks.apache.http.protocol.BasicHttpContext;
import com.mathworks.apache.http.protocol.HttpContext;
import com.mathworks.apache.http.util.CharArrayBuffer;
import com.mathworks.apache.http.util.EncodingUtils;

@NotThreadSafe
public class BasicScheme
extends RFC2617Scheme {
    private boolean complete = false;

    public BasicScheme(ChallengeState challengeState) {
        super(challengeState);
    }

    public BasicScheme() {
        this(null);
    }

    public String getSchemeName() {
        return "basic";
    }

    public void processChallenge(Header header) throws MalformedChallengeException {
        super.processChallenge(header);
        this.complete = true;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isConnectionBased() {
        return false;
    }

    @Deprecated
    public Header authenticate(Credentials credentials, HttpRequest request) throws AuthenticationException {
        return this.authenticate(credentials, request, new BasicHttpContext());
    }

    public Header authenticate(Credentials credentials, HttpRequest request, HttpContext context) throws AuthenticationException {
        if (credentials == null) {
            throw new IllegalArgumentException("Credentials may not be null");
        }
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        String charset = AuthParams.getCredentialCharset(request.getParams());
        return BasicScheme.authenticate(credentials, charset, this.isProxy());
    }

    public static Header authenticate(Credentials credentials, String charset, boolean proxy) {
        if (credentials == null) {
            throw new IllegalArgumentException("Credentials may not be null");
        }
        if (charset == null) {
            throw new IllegalArgumentException("charset may not be null");
        }
        StringBuilder tmp = new StringBuilder();
        tmp.append(credentials.getUserPrincipal().getName());
        tmp.append(":");
        tmp.append(credentials.getPassword() == null ? "null" : credentials.getPassword());
        byte[] base64password = Base64.encodeBase64(EncodingUtils.getBytes(tmp.toString(), charset));
        CharArrayBuffer buffer = new CharArrayBuffer(32);
        if (proxy) {
            buffer.append("Proxy-Authorization");
        } else {
            buffer.append("Authorization");
        }
        buffer.append(": Basic ");
        buffer.append(base64password, 0, base64password.length);
        return new BufferedHeader(buffer);
    }
}

