/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.apache.http.impl.auth;

import com.mathworks.apache.http.HeaderElement;
import com.mathworks.apache.http.annotation.NotThreadSafe;
import com.mathworks.apache.http.auth.ChallengeState;
import com.mathworks.apache.http.auth.MalformedChallengeException;
import com.mathworks.apache.http.impl.auth.AuthSchemeBase;
import com.mathworks.apache.http.message.BasicHeaderValueParser;
import com.mathworks.apache.http.message.ParserCursor;
import com.mathworks.apache.http.util.CharArrayBuffer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public abstract class RFC2617Scheme
extends AuthSchemeBase {
    private final Map<String, String> params = new HashMap<String, String>();

    public RFC2617Scheme(ChallengeState challengeState) {
        super(challengeState);
    }

    public RFC2617Scheme() {
        this(null);
    }

    @Override
    protected void parseChallenge(CharArrayBuffer buffer, int pos, int len) throws MalformedChallengeException {
        BasicHeaderValueParser parser = BasicHeaderValueParser.DEFAULT;
        ParserCursor cursor = new ParserCursor(pos, buffer.length());
        HeaderElement[] elements = parser.parseElements(buffer, cursor);
        if (elements.length == 0) {
            throw new MalformedChallengeException("Authentication challenge is empty");
        }
        this.params.clear();
        for (HeaderElement element : elements) {
            this.params.put(element.getName(), element.getValue());
        }
    }

    protected Map<String, String> getParameters() {
        return this.params;
    }

    @Override
    public String getParameter(String name) {
        if (name == null) {
            return null;
        }
        return this.params.get(name.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public String getRealm() {
        return this.getParameter("realm");
    }
}

