/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.apache.http.impl.client;

import com.mathworks.apache.http.HeaderElement;
import com.mathworks.apache.http.HttpResponse;
import com.mathworks.apache.http.annotation.Immutable;
import com.mathworks.apache.http.conn.ConnectionKeepAliveStrategy;
import com.mathworks.apache.http.message.BasicHeaderElementIterator;
import com.mathworks.apache.http.protocol.HttpContext;

@Immutable
public class DefaultConnectionKeepAliveStrategy
implements ConnectionKeepAliveStrategy {
    public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
        if (response == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
        while (it.hasNext()) {
            HeaderElement he = it.nextElement();
            String param = he.getName();
            String value = he.getValue();
            if (value == null || !param.equalsIgnoreCase("timeout")) continue;
            try {
                return Long.parseLong(value) * 1000L;
            }
            catch (NumberFormatException ignore) {
            }
        }
        return -1L;
    }
}

