/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.apache.http.impl.client;

import com.mathworks.apache.http.ConnectionReuseStrategy;
import com.mathworks.apache.http.HttpEntity;
import com.mathworks.apache.http.HttpException;
import com.mathworks.apache.http.HttpHost;
import com.mathworks.apache.http.HttpRequestInterceptor;
import com.mathworks.apache.http.HttpResponse;
import com.mathworks.apache.http.ProtocolVersion;
import com.mathworks.apache.http.auth.AuthSchemeRegistry;
import com.mathworks.apache.http.auth.AuthScope;
import com.mathworks.apache.http.auth.AuthState;
import com.mathworks.apache.http.auth.Credentials;
import com.mathworks.apache.http.client.params.HttpClientParams;
import com.mathworks.apache.http.client.protocol.RequestClientConnControl;
import com.mathworks.apache.http.client.protocol.RequestProxyAuthentication;
import com.mathworks.apache.http.conn.HttpRoutedConnection;
import com.mathworks.apache.http.conn.routing.HttpRoute;
import com.mathworks.apache.http.entity.BufferedHttpEntity;
import com.mathworks.apache.http.impl.DefaultConnectionReuseStrategy;
import com.mathworks.apache.http.impl.DefaultHttpClientConnection;
import com.mathworks.apache.http.impl.auth.BasicSchemeFactory;
import com.mathworks.apache.http.impl.auth.DigestSchemeFactory;
import com.mathworks.apache.http.impl.auth.KerberosSchemeFactory;
import com.mathworks.apache.http.impl.auth.NTLMSchemeFactory;
import com.mathworks.apache.http.impl.auth.SPNegoSchemeFactory;
import com.mathworks.apache.http.impl.client.BasicCredentialsProvider;
import com.mathworks.apache.http.impl.client.HttpAuthenticator;
import com.mathworks.apache.http.impl.client.ProxyAuthenticationStrategy;
import com.mathworks.apache.http.impl.client.TunnelRefusedException;
import com.mathworks.apache.http.message.BasicHttpRequest;
import com.mathworks.apache.http.params.BasicHttpParams;
import com.mathworks.apache.http.params.HttpParams;
import com.mathworks.apache.http.params.HttpProtocolParams;
import com.mathworks.apache.http.protocol.BasicHttpContext;
import com.mathworks.apache.http.protocol.HttpProcessor;
import com.mathworks.apache.http.protocol.HttpRequestExecutor;
import com.mathworks.apache.http.protocol.ImmutableHttpProcessor;
import com.mathworks.apache.http.protocol.RequestContent;
import com.mathworks.apache.http.protocol.RequestTargetHost;
import com.mathworks.apache.http.protocol.RequestUserAgent;
import com.mathworks.apache.http.util.EntityUtils;
import java.io.IOException;
import java.net.Socket;
import javax.net.ssl.SSLSession;

public class ProxyClient {
    private final HttpProcessor httpProcessor;
    private final HttpRequestExecutor requestExec;
    private final ProxyAuthenticationStrategy proxyAuthStrategy;
    private final HttpAuthenticator authenticator;
    private final AuthState proxyAuthState;
    private final AuthSchemeRegistry authSchemeRegistry;
    private final ConnectionReuseStrategy reuseStrategy;
    private final HttpParams params;

    public ProxyClient(HttpParams params) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.httpProcessor = new ImmutableHttpProcessor(new HttpRequestInterceptor[]{new RequestContent(), new RequestTargetHost(), new RequestClientConnControl(), new RequestUserAgent(), new RequestProxyAuthentication()});
        this.requestExec = new HttpRequestExecutor();
        this.proxyAuthStrategy = new ProxyAuthenticationStrategy();
        this.authenticator = new HttpAuthenticator();
        this.proxyAuthState = new AuthState();
        this.authSchemeRegistry = new AuthSchemeRegistry();
        this.authSchemeRegistry.register("Basic", new BasicSchemeFactory());
        this.authSchemeRegistry.register("Digest", new DigestSchemeFactory());
        this.authSchemeRegistry.register("NTLM", new NTLMSchemeFactory());
        this.authSchemeRegistry.register("negotiate", new SPNegoSchemeFactory());
        this.authSchemeRegistry.register("Kerberos", new KerberosSchemeFactory());
        this.reuseStrategy = new DefaultConnectionReuseStrategy();
        this.params = params;
    }

    public ProxyClient() {
        this(new BasicHttpParams());
    }

    public HttpParams getParams() {
        return this.params;
    }

    public AuthSchemeRegistry getAuthSchemeRegistry() {
        return this.authSchemeRegistry;
    }

    public Socket tunnel(HttpHost proxy, HttpHost target, Credentials credentials) throws IOException, HttpException {
        ProxyConnection conn = new ProxyConnection(new HttpRoute(proxy));
        BasicHttpContext context = new BasicHttpContext();
        HttpResponse response = null;
        while (true) {
            if (!conn.isOpen()) {
                Socket socket = new Socket(proxy.getHostName(), proxy.getPort());
                conn.bind(socket, this.params);
            }
            String host = target.getHostName();
            int port = target.getPort();
            if (port < 0) {
                port = 80;
            }
            StringBuilder buffer = new StringBuilder(host.length() + 6);
            buffer.append(host);
            buffer.append(':');
            buffer.append(Integer.toString(port));
            String authority = buffer.toString();
            ProtocolVersion ver = HttpProtocolParams.getVersion(this.params);
            BasicHttpRequest connect = new BasicHttpRequest("CONNECT", authority, ver);
            connect.setParams(this.params);
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(proxy), credentials);
            context.setAttribute("http.target_host", target);
            context.setAttribute("http.proxy_host", proxy);
            context.setAttribute("http.connection", conn);
            context.setAttribute("http.request", connect);
            context.setAttribute("http.auth.proxy-scope", this.proxyAuthState);
            context.setAttribute("http.auth.credentials-provider", credsProvider);
            context.setAttribute("http.authscheme-registry", this.authSchemeRegistry);
            this.requestExec.preProcess(connect, this.httpProcessor, context);
            response = this.requestExec.execute(connect, conn, context);
            response.setParams(this.params);
            this.requestExec.postProcess(response, this.httpProcessor, context);
            int status = response.getStatusLine().getStatusCode();
            if (status < 200) {
                throw new HttpException("Unexpected response to CONNECT request: " + response.getStatusLine());
            }
            if (!HttpClientParams.isAuthenticating(this.params)) continue;
            if (!this.authenticator.isAuthenticationRequested(proxy, response, this.proxyAuthStrategy, this.proxyAuthState, context) || !this.authenticator.authenticate(proxy, response, this.proxyAuthStrategy, this.proxyAuthState, context)) break;
            if (this.reuseStrategy.keepAlive(response, context)) {
                HttpEntity entity = response.getEntity();
                EntityUtils.consume(entity);
                continue;
            }
            conn.close();
        }
        int status = response.getStatusLine().getStatusCode();
        if (status > 299) {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                response.setEntity(new BufferedHttpEntity(entity));
            }
            conn.close();
            throw new TunnelRefusedException("CONNECT refused by proxy: " + response.getStatusLine(), response);
        }
        return conn.getSocket();
    }

    static class ProxyConnection
    extends DefaultHttpClientConnection
    implements HttpRoutedConnection {
        private final HttpRoute route;

        ProxyConnection(HttpRoute route) {
            this.route = route;
        }

        public HttpRoute getRoute() {
            return this.route;
        }

        public boolean isSecure() {
            return false;
        }

        public SSLSession getSSLSession() {
            return null;
        }

        public Socket getSocket() {
            return super.getSocket();
        }
    }
}

