/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.apache.http.impl.conn;

import com.mathworks.apache.http.HttpException;
import com.mathworks.apache.http.HttpHost;
import com.mathworks.apache.http.HttpRequest;
import com.mathworks.apache.http.annotation.ThreadSafe;
import com.mathworks.apache.http.conn.params.ConnRouteParams;
import com.mathworks.apache.http.conn.routing.HttpRoute;
import com.mathworks.apache.http.conn.routing.HttpRoutePlanner;
import com.mathworks.apache.http.conn.scheme.Scheme;
import com.mathworks.apache.http.conn.scheme.SchemeRegistry;
import com.mathworks.apache.http.protocol.HttpContext;
import java.net.InetAddress;

@ThreadSafe
public class DefaultHttpRoutePlanner
implements HttpRoutePlanner {
    protected final SchemeRegistry schemeRegistry;

    public DefaultHttpRoutePlanner(SchemeRegistry schreg) {
        if (schreg == null) {
            throw new IllegalArgumentException("SchemeRegistry must not be null.");
        }
        this.schemeRegistry = schreg;
    }

    public HttpRoute determineRoute(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        Scheme schm;
        if (request == null) {
            throw new IllegalStateException("Request must not be null.");
        }
        HttpRoute route = ConnRouteParams.getForcedRoute(request.getParams());
        if (route != null) {
            return route;
        }
        if (target == null) {
            throw new IllegalStateException("Target host must not be null.");
        }
        InetAddress local = ConnRouteParams.getLocalAddress(request.getParams());
        HttpHost proxy = ConnRouteParams.getDefaultProxy(request.getParams());
        try {
            schm = this.schemeRegistry.getScheme(target.getSchemeName());
        }
        catch (IllegalStateException ex) {
            throw new HttpException(ex.getMessage());
        }
        boolean secure = schm.isLayered();
        route = proxy == null ? new HttpRoute(target, local, secure) : new HttpRoute(target, local, proxy, secure);
        return route;
    }
}

