/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.apache.http.impl.entity;

import com.mathworks.apache.http.HttpException;
import com.mathworks.apache.http.HttpMessage;
import com.mathworks.apache.http.ProtocolException;
import com.mathworks.apache.http.annotation.Immutable;
import com.mathworks.apache.http.entity.ContentLengthStrategy;

@Immutable
public class DisallowIdentityContentLengthStrategy
implements ContentLengthStrategy {
    private final ContentLengthStrategy contentLengthStrategy;

    public DisallowIdentityContentLengthStrategy(ContentLengthStrategy contentLengthStrategy) {
        this.contentLengthStrategy = contentLengthStrategy;
    }

    public long determineLength(HttpMessage message) throws HttpException {
        long result = this.contentLengthStrategy.determineLength(message);
        if (result == -1L) {
            throw new ProtocolException("Identity transfer encoding cannot be used");
        }
        return result;
    }
}

