/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.apache.http.impl.nio;

import com.mathworks.apache.http.annotation.Immutable;
import com.mathworks.apache.http.impl.nio.DefaultNHttpServerConnection;
import com.mathworks.apache.http.impl.nio.DefaultNHttpServerConnectionFactory;
import com.mathworks.apache.http.impl.nio.SSLNHttpServerConnectionFactory;
import com.mathworks.apache.http.impl.nio.reactor.AbstractIODispatch;
import com.mathworks.apache.http.nio.NHttpConnectionFactory;
import com.mathworks.apache.http.nio.NHttpServerEventHandler;
import com.mathworks.apache.http.nio.reactor.IOSession;
import com.mathworks.apache.http.nio.reactor.ssl.SSLSetupHandler;
import com.mathworks.apache.http.params.HttpParams;
import java.io.IOException;
import javax.net.ssl.SSLContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class DefaultHttpServerIODispatch
extends AbstractIODispatch<DefaultNHttpServerConnection> {
    private final NHttpServerEventHandler handler;
    private final NHttpConnectionFactory<DefaultNHttpServerConnection> connFactory;

    public DefaultHttpServerIODispatch(NHttpServerEventHandler handler, NHttpConnectionFactory<DefaultNHttpServerConnection> connFactory) {
        if (handler == null) {
            throw new IllegalArgumentException("HTTP client handler may not be null");
        }
        if (connFactory == null) {
            throw new IllegalArgumentException("HTTP server connection factory is null");
        }
        this.handler = handler;
        this.connFactory = connFactory;
    }

    public DefaultHttpServerIODispatch(NHttpServerEventHandler handler, HttpParams params) {
        this(handler, new DefaultNHttpServerConnectionFactory(params));
    }

    public DefaultHttpServerIODispatch(NHttpServerEventHandler handler, SSLContext sslcontext, SSLSetupHandler sslHandler, HttpParams params) {
        this(handler, new SSLNHttpServerConnectionFactory(sslcontext, sslHandler, params));
    }

    public DefaultHttpServerIODispatch(NHttpServerEventHandler handler, SSLContext sslcontext, HttpParams params) {
        this(handler, sslcontext, null, params);
    }

    @Override
    protected DefaultNHttpServerConnection createConnection(IOSession session) {
        return this.connFactory.createConnection(session);
    }

    @Override
    protected void onConnected(DefaultNHttpServerConnection conn) {
        try {
            this.handler.connected(conn);
        }
        catch (Exception ex) {
            this.handler.exception(conn, ex);
        }
    }

    @Override
    protected void onClosed(DefaultNHttpServerConnection conn) {
        this.handler.closed(conn);
    }

    @Override
    protected void onException(DefaultNHttpServerConnection conn, IOException ex) {
        this.handler.exception(conn, ex);
    }

    @Override
    protected void onInputReady(DefaultNHttpServerConnection conn) {
        conn.consumeInput(this.handler);
    }

    @Override
    protected void onOutputReady(DefaultNHttpServerConnection conn) {
        conn.produceOutput(this.handler);
    }

    @Override
    protected void onTimeout(DefaultNHttpServerConnection conn) {
        try {
            this.handler.timeout(conn);
        }
        catch (Exception ex) {
            this.handler.exception(conn, ex);
        }
    }
}

