/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.apache.http.impl.nio;

import com.mathworks.apache.http.HttpResponseFactory;
import com.mathworks.apache.http.annotation.Immutable;
import com.mathworks.apache.http.impl.DefaultHttpResponseFactory;
import com.mathworks.apache.http.impl.nio.DefaultNHttpClientConnection;
import com.mathworks.apache.http.nio.NHttpConnectionFactory;
import com.mathworks.apache.http.nio.reactor.IOSession;
import com.mathworks.apache.http.nio.reactor.ssl.SSLIOSession;
import com.mathworks.apache.http.nio.reactor.ssl.SSLMode;
import com.mathworks.apache.http.nio.reactor.ssl.SSLSetupHandler;
import com.mathworks.apache.http.nio.util.ByteBufferAllocator;
import com.mathworks.apache.http.nio.util.HeapByteBufferAllocator;
import com.mathworks.apache.http.params.HttpConnectionParams;
import com.mathworks.apache.http.params.HttpParams;
import javax.net.ssl.SSLContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class SSLNHttpClientConnectionFactory
implements NHttpConnectionFactory<DefaultNHttpClientConnection> {
    private final HttpResponseFactory responseFactory;
    private final ByteBufferAllocator allocator;
    private final SSLContext sslcontext;
    private final SSLSetupHandler sslHandler;
    private final HttpParams params;

    public SSLNHttpClientConnectionFactory(SSLContext sslcontext, SSLSetupHandler sslHandler, HttpResponseFactory responseFactory, ByteBufferAllocator allocator, HttpParams params) {
        if (responseFactory == null) {
            throw new IllegalArgumentException("HTTP response factory may not be null");
        }
        if (allocator == null) {
            throw new IllegalArgumentException("Byte buffer allocator may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.sslcontext = sslcontext;
        this.sslHandler = sslHandler;
        this.responseFactory = responseFactory;
        this.allocator = allocator;
        this.params = params;
    }

    public SSLNHttpClientConnectionFactory(SSLContext sslcontext, SSLSetupHandler sslHandler, HttpParams params) {
        this(sslcontext, sslHandler, new DefaultHttpResponseFactory(), new HeapByteBufferAllocator(), params);
    }

    public SSLNHttpClientConnectionFactory(HttpParams params) {
        this(null, null, params);
    }

    private SSLContext getDefaultSSLContext() {
        SSLContext sslcontext;
        try {
            sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(null, null, null);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failure initializing default SSL context", ex);
        }
        return sslcontext;
    }

    protected DefaultNHttpClientConnection createConnection(IOSession session, HttpResponseFactory responseFactory, ByteBufferAllocator allocator, HttpParams params) {
        return new DefaultNHttpClientConnection(session, responseFactory, allocator, params);
    }

    @Override
    public DefaultNHttpClientConnection createConnection(IOSession session) {
        SSLContext sslcontext = this.sslcontext != null ? this.sslcontext : this.getDefaultSSLContext();
        SSLIOSession ssliosession = new SSLIOSession(session, SSLMode.CLIENT, sslcontext, this.sslHandler);
        session.setAttribute("http.session.ssl", ssliosession);
        DefaultNHttpClientConnection conn = this.createConnection(ssliosession, this.responseFactory, this.allocator, this.params);
        int timeout = HttpConnectionParams.getSoTimeout(this.params);
        conn.setSocketTimeout(timeout);
        return conn;
    }
}

