/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.apache.http.impl.nio.client;

import com.mathworks.apache.http.HttpVersion;
import com.mathworks.apache.http.client.protocol.RequestAddCookies;
import com.mathworks.apache.http.client.protocol.RequestAuthCache;
import com.mathworks.apache.http.client.protocol.RequestClientConnControl;
import com.mathworks.apache.http.client.protocol.RequestDefaultHeaders;
import com.mathworks.apache.http.client.protocol.RequestProxyAuthentication;
import com.mathworks.apache.http.client.protocol.RequestTargetAuthentication;
import com.mathworks.apache.http.client.protocol.ResponseProcessCookies;
import com.mathworks.apache.http.impl.client.DefaultHttpClient;
import com.mathworks.apache.http.impl.nio.client.AbstractHttpAsyncClient;
import com.mathworks.apache.http.impl.nio.reactor.IOReactorConfig;
import com.mathworks.apache.http.nio.conn.ClientAsyncConnectionManager;
import com.mathworks.apache.http.nio.reactor.IOReactorException;
import com.mathworks.apache.http.params.HttpConnectionParams;
import com.mathworks.apache.http.params.HttpParams;
import com.mathworks.apache.http.params.HttpProtocolParams;
import com.mathworks.apache.http.params.SyncBasicHttpParams;
import com.mathworks.apache.http.protocol.BasicHttpProcessor;
import com.mathworks.apache.http.protocol.HTTP;
import com.mathworks.apache.http.protocol.RequestContent;
import com.mathworks.apache.http.protocol.RequestExpectContinue;
import com.mathworks.apache.http.protocol.RequestTargetHost;
import com.mathworks.apache.http.protocol.RequestUserAgent;
import com.mathworks.apache.http.util.VersionInfo;

public class DefaultHttpAsyncClient
extends AbstractHttpAsyncClient {
    public DefaultHttpAsyncClient(ClientAsyncConnectionManager connmgr) {
        super(connmgr);
    }

    public DefaultHttpAsyncClient(IOReactorConfig config) throws IOReactorException {
        super(config);
    }

    public DefaultHttpAsyncClient() throws IOReactorException {
        super(new IOReactorConfig());
    }

    protected HttpParams createHttpParams() {
        SyncBasicHttpParams params = new SyncBasicHttpParams();
        DefaultHttpAsyncClient.setDefaultHttpParams(params);
        return params;
    }

    public static void setDefaultHttpParams(HttpParams params) {
        HttpProtocolParams.setVersion(params, HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset(params, HTTP.DEF_CONTENT_CHARSET.name());
        HttpConnectionParams.setTcpNoDelay(params, true);
        HttpConnectionParams.setSocketBufferSize(params, 8192);
        VersionInfo vi = VersionInfo.loadVersionInfo("com.mathworks.apache.http.nio.client", DefaultHttpClient.class.getClassLoader());
        String release = vi != null ? vi.getRelease() : "UNAVAILABLE";
        HttpProtocolParams.setUserAgent(params, "Apache-HttpAsyncClient/" + release + " (java 1.5)");
    }

    protected BasicHttpProcessor createHttpProcessor() {
        BasicHttpProcessor httpproc = new BasicHttpProcessor();
        httpproc.addInterceptor(new RequestDefaultHeaders());
        httpproc.addInterceptor(new RequestContent());
        httpproc.addInterceptor(new RequestTargetHost());
        httpproc.addInterceptor(new RequestClientConnControl());
        httpproc.addInterceptor(new RequestUserAgent());
        httpproc.addInterceptor(new RequestExpectContinue());
        httpproc.addInterceptor(new RequestAddCookies());
        httpproc.addInterceptor(new ResponseProcessCookies());
        httpproc.addInterceptor(new RequestAuthCache());
        httpproc.addInterceptor(new RequestTargetAuthentication());
        httpproc.addInterceptor(new RequestProxyAuthentication());
        return httpproc;
    }
}

