/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.apache.http.impl.nio.codecs;

import com.mathworks.apache.http.Header;
import com.mathworks.apache.http.MalformedChunkCodingException;
import com.mathworks.apache.http.ParseException;
import com.mathworks.apache.http.TruncatedChunkException;
import com.mathworks.apache.http.annotation.NotThreadSafe;
import com.mathworks.apache.http.impl.io.HttpTransportMetricsImpl;
import com.mathworks.apache.http.impl.nio.codecs.AbstractContentDecoder;
import com.mathworks.apache.http.message.BufferedHeader;
import com.mathworks.apache.http.nio.reactor.SessionInputBuffer;
import com.mathworks.apache.http.util.CharArrayBuffer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.List;

@NotThreadSafe
public class ChunkDecoder
extends AbstractContentDecoder {
    private static final int READ_CONTENT = 0;
    private static final int READ_FOOTERS = 1;
    private static final int COMPLETED = 2;
    private int state = 0;
    private boolean endOfChunk = false;
    private boolean endOfStream = false;
    private CharArrayBuffer lineBuf;
    private int chunkSize = -1;
    private int pos = 0;
    private final List<CharArrayBuffer> trailerBufs = new ArrayList<CharArrayBuffer>();
    private Header[] footers;

    public ChunkDecoder(ReadableByteChannel channel, SessionInputBuffer buffer, HttpTransportMetricsImpl metrics) {
        super(channel, buffer, metrics);
    }

    private void readChunkHead() throws IOException {
        if (this.endOfChunk) {
            if (this.buffer.length() < 2) {
                return;
            }
            int cr = this.buffer.read();
            int lf = this.buffer.read();
            if (cr != 13 || lf != 10) {
                throw new MalformedChunkCodingException("CRLF expected at end of chunk");
            }
            this.endOfChunk = false;
        }
        if (this.lineBuf == null) {
            this.lineBuf = new CharArrayBuffer(32);
        } else {
            this.lineBuf.clear();
        }
        if (this.buffer.readLine(this.lineBuf, this.endOfStream)) {
            int separator = this.lineBuf.indexOf(59);
            if (separator < 0) {
                separator = this.lineBuf.length();
            }
            try {
                String s = this.lineBuf.substringTrimmed(0, separator);
                this.chunkSize = Integer.parseInt(s, 16);
            }
            catch (NumberFormatException e) {
                throw new MalformedChunkCodingException("Bad chunk header");
            }
            this.pos = 0;
        }
    }

    private void parseHeader() {
        CharArrayBuffer current = this.lineBuf;
        int count = this.trailerBufs.size();
        if ((this.lineBuf.charAt(0) == ' ' || this.lineBuf.charAt(0) == '\t') && count > 0) {
            char ch;
            int i;
            CharArrayBuffer previous = this.trailerBufs.get(count - 1);
            for (i = 0; i < current.length() && ((ch = current.charAt(i)) == ' ' || ch == '\t'); ++i) {
            }
            previous.append(' ');
            previous.append(current, i, current.length() - i);
        } else {
            this.trailerBufs.add(current);
            this.lineBuf = null;
        }
    }

    private void processFooters() throws IOException {
        int count = this.trailerBufs.size();
        if (count > 0) {
            this.footers = new Header[this.trailerBufs.size()];
            for (int i = 0; i < this.trailerBufs.size(); ++i) {
                CharArrayBuffer buffer = this.trailerBufs.get(i);
                try {
                    this.footers[i] = new BufferedHeader(buffer);
                    continue;
                }
                catch (ParseException ex) {
                    throw new IOException(ex.getMessage());
                }
            }
        }
        this.trailerBufs.clear();
    }

    public int read(ByteBuffer dst) throws IOException {
        if (dst == null) {
            throw new IllegalArgumentException("Byte buffer may not be null");
        }
        if (this.state == 2) {
            return -1;
        }
        int totalRead = 0;
        while (this.state != 2) {
            if (!this.buffer.hasData() || this.chunkSize == -1) {
                int bytesRead = this.buffer.fill(this.channel);
                if (bytesRead > 0) {
                    this.metrics.incrementBytesTransferred(bytesRead);
                }
                if (bytesRead == -1) {
                    this.endOfStream = true;
                }
            }
            switch (this.state) {
                case 0: {
                    int maxLen;
                    int len;
                    if (this.chunkSize == -1) {
                        this.readChunkHead();
                        if (this.chunkSize == -1) {
                            if (this.endOfStream) {
                                this.state = 2;
                                this.completed = true;
                            }
                            return totalRead;
                        }
                        if (this.chunkSize == 0) {
                            this.chunkSize = -1;
                            this.state = 1;
                            break;
                        }
                    }
                    if ((len = this.buffer.read(dst, maxLen = this.chunkSize - this.pos)) > 0) {
                        this.pos += len;
                        totalRead += len;
                    } else if (!this.buffer.hasData() && this.endOfStream) {
                        this.state = 2;
                        this.completed = true;
                        throw new TruncatedChunkException("Truncated chunk ( expected size: " + this.chunkSize + "; actual size: " + this.pos + ")");
                    }
                    if (this.pos == this.chunkSize) {
                        this.chunkSize = -1;
                        this.pos = 0;
                        this.endOfChunk = true;
                        break;
                    }
                    return totalRead;
                }
                case 1: {
                    if (this.lineBuf == null) {
                        this.lineBuf = new CharArrayBuffer(32);
                    } else {
                        this.lineBuf.clear();
                    }
                    if (!this.buffer.readLine(this.lineBuf, this.endOfStream)) {
                        if (this.endOfStream) {
                            this.state = 2;
                            this.completed = true;
                        }
                        return totalRead;
                    }
                    if (this.lineBuf.length() > 0) {
                        this.parseHeader();
                        break;
                    }
                    this.state = 2;
                    this.completed = true;
                    this.processFooters();
                }
            }
        }
        return totalRead;
    }

    public Header[] getFooters() {
        if (this.footers != null) {
            return (Header[])this.footers.clone();
        }
        return new Header[0];
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[chunk-coded; completed: ");
        buffer.append(this.completed);
        buffer.append("]");
        return buffer.toString();
    }
}

