/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.apache.http.impl.nio.codecs;

import com.mathworks.apache.http.HttpException;
import com.mathworks.apache.http.HttpRequest;
import com.mathworks.apache.http.HttpRequestFactory;
import com.mathworks.apache.http.ParseException;
import com.mathworks.apache.http.RequestLine;
import com.mathworks.apache.http.annotation.NotThreadSafe;
import com.mathworks.apache.http.impl.nio.codecs.AbstractMessageParser;
import com.mathworks.apache.http.message.LineParser;
import com.mathworks.apache.http.message.ParserCursor;
import com.mathworks.apache.http.nio.reactor.SessionInputBuffer;
import com.mathworks.apache.http.params.HttpParams;
import com.mathworks.apache.http.util.CharArrayBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class DefaultHttpRequestParser
extends AbstractMessageParser<HttpRequest> {
    private final HttpRequestFactory requestFactory;

    public DefaultHttpRequestParser(SessionInputBuffer buffer, LineParser parser, HttpRequestFactory requestFactory, HttpParams params) {
        super(buffer, parser, params);
        if (requestFactory == null) {
            throw new IllegalArgumentException("Request factory may not be null");
        }
        this.requestFactory = requestFactory;
    }

    @Override
    protected HttpRequest createMessage(CharArrayBuffer buffer) throws HttpException, ParseException {
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        RequestLine requestLine = this.lineParser.parseRequestLine(buffer, cursor);
        return this.requestFactory.newHttpRequest(requestLine);
    }
}

