/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.apache.http.impl.nio.pool;

import com.mathworks.apache.http.HttpHost;
import com.mathworks.apache.http.HttpResponseFactory;
import com.mathworks.apache.http.annotation.Immutable;
import com.mathworks.apache.http.impl.DefaultHttpResponseFactory;
import com.mathworks.apache.http.impl.nio.DefaultNHttpClientConnectionFactory;
import com.mathworks.apache.http.impl.nio.SSLNHttpClientConnectionFactory;
import com.mathworks.apache.http.nio.NHttpClientConnection;
import com.mathworks.apache.http.nio.NHttpConnectionFactory;
import com.mathworks.apache.http.nio.pool.NIOConnFactory;
import com.mathworks.apache.http.nio.reactor.IOSession;
import com.mathworks.apache.http.nio.reactor.ssl.SSLSetupHandler;
import com.mathworks.apache.http.nio.util.ByteBufferAllocator;
import com.mathworks.apache.http.nio.util.HeapByteBufferAllocator;
import com.mathworks.apache.http.params.HttpParams;
import java.io.IOException;
import javax.net.ssl.SSLContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class BasicNIOConnFactory
implements NIOConnFactory<HttpHost, NHttpClientConnection> {
    private final NHttpConnectionFactory<? extends NHttpClientConnection> plainFactory;
    private final NHttpConnectionFactory<? extends NHttpClientConnection> sslFactory;

    public BasicNIOConnFactory(NHttpConnectionFactory<? extends NHttpClientConnection> plainFactory, NHttpConnectionFactory<? extends NHttpClientConnection> sslFactory) {
        if (plainFactory == null) {
            throw new IllegalArgumentException("Plain HTTP client connection factory may not be null");
        }
        this.plainFactory = plainFactory;
        this.sslFactory = sslFactory;
    }

    public BasicNIOConnFactory(NHttpConnectionFactory<? extends NHttpClientConnection> plainFactory) {
        this(plainFactory, null);
    }

    public BasicNIOConnFactory(SSLContext sslcontext, SSLSetupHandler sslHandler, HttpResponseFactory responseFactory, ByteBufferAllocator allocator, HttpParams params) {
        this(new DefaultNHttpClientConnectionFactory(responseFactory, allocator, params), new SSLNHttpClientConnectionFactory(sslcontext, sslHandler, responseFactory, allocator, params));
    }

    public BasicNIOConnFactory(SSLContext sslcontext, SSLSetupHandler sslHandler, HttpParams params) {
        this(sslcontext, sslHandler, new DefaultHttpResponseFactory(), new HeapByteBufferAllocator(), params);
    }

    public BasicNIOConnFactory(HttpParams params) {
        this(null, null, params);
    }

    @Override
    public NHttpClientConnection create(HttpHost route, IOSession session) throws IOException {
        NHttpClientConnection conn;
        if (route.getSchemeName().equalsIgnoreCase("https")) {
            if (this.sslFactory == null) {
                throw new IOException("SSL not supported");
            }
            conn = this.sslFactory.createConnection(session);
        } else {
            conn = this.plainFactory.createConnection(session);
        }
        session.setAttribute("http.connection", conn);
        return conn;
    }
}

