/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.apache.http.impl.nio.pool;

import com.mathworks.apache.http.HttpHost;
import com.mathworks.apache.http.annotation.ThreadSafe;
import com.mathworks.apache.http.concurrent.FutureCallback;
import com.mathworks.apache.http.impl.nio.pool.BasicNIOConnFactory;
import com.mathworks.apache.http.impl.nio.pool.BasicNIOPoolEntry;
import com.mathworks.apache.http.nio.NHttpClientConnection;
import com.mathworks.apache.http.nio.pool.AbstractNIOConnPool;
import com.mathworks.apache.http.nio.pool.NIOConnFactory;
import com.mathworks.apache.http.nio.reactor.ConnectingIOReactor;
import com.mathworks.apache.http.params.HttpConnectionParams;
import com.mathworks.apache.http.params.HttpParams;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class BasicNIOConnPool
extends AbstractNIOConnPool<HttpHost, NHttpClientConnection, BasicNIOPoolEntry> {
    private static AtomicLong COUNTER = new AtomicLong();
    private final HttpParams params;

    public BasicNIOConnPool(ConnectingIOReactor ioreactor, NIOConnFactory<HttpHost, NHttpClientConnection> connFactory, HttpParams params) {
        super(ioreactor, connFactory, 2, 20);
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.params = params;
    }

    public BasicNIOConnPool(ConnectingIOReactor ioreactor, HttpParams params) {
        this(ioreactor, new BasicNIOConnFactory(params), params);
    }

    @Override
    protected SocketAddress resolveRemoteAddress(HttpHost host) {
        return new InetSocketAddress(host.getHostName(), host.getPort());
    }

    @Override
    protected SocketAddress resolveLocalAddress(HttpHost host) {
        return null;
    }

    @Override
    protected BasicNIOPoolEntry createEntry(HttpHost host, NHttpClientConnection conn) {
        return new BasicNIOPoolEntry(Long.toString(COUNTER.getAndIncrement()), host, conn);
    }

    @Override
    public Future<BasicNIOPoolEntry> lease(HttpHost route, Object state, FutureCallback<BasicNIOPoolEntry> callback) {
        int connectTimeout = HttpConnectionParams.getConnectionTimeout(this.params);
        return super.lease(route, state, connectTimeout, TimeUnit.MILLISECONDS, callback);
    }

    @Override
    public Future<BasicNIOPoolEntry> lease(HttpHost route, Object state) {
        int connectTimeout = HttpConnectionParams.getConnectionTimeout(this.params);
        return super.lease(route, state, connectTimeout, TimeUnit.MILLISECONDS, null);
    }
}

