/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.apache.http.impl.nio.reactor;

import com.mathworks.apache.http.annotation.NotThreadSafe;
import com.mathworks.apache.http.nio.reactor.SessionInputBuffer;
import com.mathworks.apache.http.nio.util.ByteBufferAllocator;
import com.mathworks.apache.http.nio.util.ExpandableBuffer;
import com.mathworks.apache.http.nio.util.HeapByteBufferAllocator;
import com.mathworks.apache.http.params.HttpParams;
import com.mathworks.apache.http.params.HttpProtocolParams;
import com.mathworks.apache.http.util.CharArrayBuffer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

@NotThreadSafe
public class SessionInputBufferImpl
extends ExpandableBuffer
implements SessionInputBuffer {
    private CharBuffer charbuffer = null;
    private Charset charset = null;
    private CharsetDecoder chardecoder = null;

    public SessionInputBufferImpl(int buffersize, int linebuffersize, ByteBufferAllocator allocator, HttpParams params) {
        super(buffersize, allocator);
        this.charbuffer = CharBuffer.allocate(linebuffersize);
        this.charset = Charset.forName(HttpProtocolParams.getHttpElementCharset(params));
        this.chardecoder = this.charset.newDecoder();
        this.chardecoder.onMalformedInput(HttpProtocolParams.getMalformedInputAction(params));
        this.chardecoder.onUnmappableCharacter(HttpProtocolParams.getUnmappableInputAction(params));
    }

    public SessionInputBufferImpl(int buffersize, int linebuffersize, HttpParams params) {
        this(buffersize, linebuffersize, new HeapByteBufferAllocator(), params);
    }

    public int fill(ReadableByteChannel channel) throws IOException {
        if (channel == null) {
            throw new IllegalArgumentException("Channel may not be null");
        }
        this.setInputMode();
        if (!this.buffer.hasRemaining()) {
            this.expand();
        }
        int readNo = channel.read(this.buffer);
        return readNo;
    }

    public int read() {
        this.setOutputMode();
        return this.buffer.get() & 0xFF;
    }

    public int read(ByteBuffer dst, int maxLen) {
        if (dst == null) {
            return 0;
        }
        this.setOutputMode();
        int len = Math.min(dst.remaining(), maxLen);
        int chunk = Math.min(this.buffer.remaining(), len);
        for (int i = 0; i < chunk; ++i) {
            dst.put(this.buffer.get());
        }
        return chunk;
    }

    public int read(ByteBuffer dst) {
        if (dst == null) {
            return 0;
        }
        return this.read(dst, dst.remaining());
    }

    public int read(WritableByteChannel dst, int maxLen) throws IOException {
        int bytesRead;
        if (dst == null) {
            return 0;
        }
        this.setOutputMode();
        if (this.buffer.remaining() > maxLen) {
            int oldLimit = this.buffer.limit();
            int newLimit = oldLimit - (this.buffer.remaining() - maxLen);
            this.buffer.limit(newLimit);
            bytesRead = dst.write(this.buffer);
            this.buffer.limit(oldLimit);
        } else {
            bytesRead = dst.write(this.buffer);
        }
        return bytesRead;
    }

    public int read(WritableByteChannel dst) throws IOException {
        if (dst == null) {
            return 0;
        }
        this.setOutputMode();
        return dst.write(this.buffer);
    }

    public boolean readLine(CharArrayBuffer linebuffer, boolean endOfStream) throws CharacterCodingException {
        int l;
        CoderResult result;
        this.setOutputMode();
        int pos = -1;
        boolean hasLine = false;
        for (int i = this.buffer.position(); i < this.buffer.limit(); ++i) {
            byte b = this.buffer.get(i);
            if (b != 10) continue;
            hasLine = true;
            pos = i + 1;
            break;
        }
        if (!hasLine) {
            if (endOfStream && this.buffer.hasRemaining()) {
                pos = this.buffer.limit();
            } else {
                return false;
            }
        }
        int origLimit = this.buffer.limit();
        this.buffer.limit(pos);
        int len = this.buffer.limit() - this.buffer.position();
        linebuffer.ensureCapacity(len);
        this.chardecoder.reset();
        do {
            if ((result = this.chardecoder.decode(this.buffer, this.charbuffer, true)).isError()) {
                result.throwException();
            }
            if (!result.isOverflow()) continue;
            this.charbuffer.flip();
            linebuffer.append(this.charbuffer.array(), this.charbuffer.position(), this.charbuffer.remaining());
            this.charbuffer.clear();
        } while (!result.isUnderflow());
        this.buffer.limit(origLimit);
        this.chardecoder.flush(this.charbuffer);
        this.charbuffer.flip();
        if (this.charbuffer.hasRemaining()) {
            linebuffer.append(this.charbuffer.array(), this.charbuffer.position(), this.charbuffer.remaining());
        }
        if ((l = linebuffer.length()) > 0) {
            if (linebuffer.charAt(l - 1) == '\n') {
                linebuffer.setLength(--l);
            }
            if (l > 0 && linebuffer.charAt(l - 1) == '\r') {
                linebuffer.setLength(--l);
            }
        }
        return true;
    }

    public String readLine(boolean endOfStream) throws CharacterCodingException {
        CharArrayBuffer charbuffer = new CharArrayBuffer(64);
        boolean found = this.readLine(charbuffer, endOfStream);
        if (found) {
            return charbuffer.toString();
        }
        return null;
    }
}

