/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.apache.http.impl.nio.reactor;

import com.mathworks.apache.http.annotation.NotThreadSafe;
import com.mathworks.apache.http.nio.reactor.SessionOutputBuffer;
import com.mathworks.apache.http.nio.util.ByteBufferAllocator;
import com.mathworks.apache.http.nio.util.ExpandableBuffer;
import com.mathworks.apache.http.nio.util.HeapByteBufferAllocator;
import com.mathworks.apache.http.params.HttpParams;
import com.mathworks.apache.http.params.HttpProtocolParams;
import com.mathworks.apache.http.util.CharArrayBuffer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

@NotThreadSafe
public class SessionOutputBufferImpl
extends ExpandableBuffer
implements SessionOutputBuffer {
    private static final byte[] CRLF = new byte[]{13, 10};
    private CharBuffer charbuffer = null;
    private Charset charset = null;
    private CharsetEncoder charencoder = null;

    public SessionOutputBufferImpl(int buffersize, int linebuffersize, ByteBufferAllocator allocator, HttpParams params) {
        super(buffersize, allocator);
        this.charbuffer = CharBuffer.allocate(linebuffersize);
        this.charset = Charset.forName(HttpProtocolParams.getHttpElementCharset(params));
        this.charencoder = this.charset.newEncoder();
        this.charencoder.onMalformedInput(HttpProtocolParams.getMalformedInputAction(params));
        this.charencoder.onUnmappableCharacter(HttpProtocolParams.getUnmappableInputAction(params));
    }

    public SessionOutputBufferImpl(int buffersize, int linebuffersize, HttpParams params) {
        this(buffersize, linebuffersize, new HeapByteBufferAllocator(), params);
    }

    public void reset(HttpParams params) {
        this.clear();
    }

    public int flush(WritableByteChannel channel) throws IOException {
        if (channel == null) {
            throw new IllegalArgumentException("Channel may not be null");
        }
        this.setOutputMode();
        int noWritten = channel.write(this.buffer);
        return noWritten;
    }

    public void write(ByteBuffer src) {
        if (src == null) {
            return;
        }
        this.setInputMode();
        int requiredCapacity = this.buffer.position() + src.remaining();
        this.ensureCapacity(requiredCapacity);
        this.buffer.put(src);
    }

    public void write(ReadableByteChannel src) throws IOException {
        if (src == null) {
            return;
        }
        this.setInputMode();
        src.read(this.buffer);
    }

    private void write(byte[] b) {
        if (b == null) {
            return;
        }
        this.setInputMode();
        int off = 0;
        int len = b.length;
        int requiredCapacity = this.buffer.position() + len;
        this.ensureCapacity(requiredCapacity);
        this.buffer.put(b, off, len);
    }

    private void writeCRLF() {
        this.write(CRLF);
    }

    public void writeLine(CharArrayBuffer linebuffer) throws CharacterCodingException {
        if (linebuffer == null) {
            return;
        }
        if (linebuffer.length() > 0) {
            int l;
            this.setInputMode();
            this.charencoder.reset();
            int offset = 0;
            for (int remaining = linebuffer.length(); remaining > 0; remaining -= l) {
                l = this.charbuffer.remaining();
                boolean eol = false;
                if (remaining <= l) {
                    l = remaining;
                    eol = true;
                }
                this.charbuffer.put(linebuffer.buffer(), offset, l);
                this.charbuffer.flip();
                boolean retry = true;
                while (retry) {
                    CoderResult result = this.charencoder.encode(this.charbuffer, this.buffer, eol);
                    if (result.isError()) {
                        result.throwException();
                    }
                    if (result.isOverflow()) {
                        this.expand();
                    }
                    retry = !result.isUnderflow();
                }
                this.charbuffer.compact();
                offset += l;
            }
            boolean retry = true;
            while (retry) {
                CoderResult result = this.charencoder.flush(this.buffer);
                if (result.isError()) {
                    result.throwException();
                }
                if (result.isOverflow()) {
                    this.expand();
                }
                retry = !result.isUnderflow();
            }
        }
        this.writeCRLF();
    }

    public void writeLine(String s) throws IOException {
        if (s == null) {
            return;
        }
        if (s.length() > 0) {
            CharArrayBuffer tmp = new CharArrayBuffer(s.length());
            tmp.append(s);
            this.writeLine(tmp);
        } else {
            this.write(CRLF);
        }
    }
}

