/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.apache.http.nio.entity;

import com.mathworks.apache.http.HttpEntity;
import com.mathworks.apache.http.annotation.NotThreadSafe;
import com.mathworks.apache.http.nio.ContentEncoder;
import com.mathworks.apache.http.nio.IOControl;
import com.mathworks.apache.http.nio.entity.HttpAsyncContentProducer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;

@NotThreadSafe
public class EntityAsyncContentProducer
implements HttpAsyncContentProducer {
    private final HttpEntity entity;
    private final ByteBuffer buffer;
    private ReadableByteChannel channel;

    public EntityAsyncContentProducer(HttpEntity entity) {
        if (entity == null) {
            throw new IllegalArgumentException("HTTP entity may not be null");
        }
        this.entity = entity;
        this.buffer = ByteBuffer.allocate(4096);
    }

    public void produceContent(ContentEncoder encoder, IOControl ioctrl) throws IOException {
        if (this.channel == null) {
            this.channel = Channels.newChannel(this.entity.getContent());
        }
        int i = this.channel.read(this.buffer);
        this.buffer.flip();
        encoder.write(this.buffer);
        boolean buffering = this.buffer.hasRemaining();
        this.buffer.compact();
        if (i == -1 && !buffering) {
            encoder.complete();
            this.close();
        }
    }

    public boolean isRepeatable() {
        return this.entity.isRepeatable();
    }

    public void close() throws IOException {
        ReadableByteChannel local = this.channel;
        this.channel = null;
        if (local != null) {
            local.close();
        }
    }
}

