/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.apache.http.protocol;

import com.mathworks.apache.http.HttpEntity;
import com.mathworks.apache.http.HttpEntityEnclosingRequest;
import com.mathworks.apache.http.HttpException;
import com.mathworks.apache.http.HttpRequest;
import com.mathworks.apache.http.HttpRequestInterceptor;
import com.mathworks.apache.http.HttpVersion;
import com.mathworks.apache.http.ProtocolVersion;
import com.mathworks.apache.http.annotation.Immutable;
import com.mathworks.apache.http.params.HttpProtocolParams;
import com.mathworks.apache.http.protocol.HttpContext;
import java.io.IOException;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        HttpEntity entity;
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (request instanceof HttpEntityEnclosingRequest && (entity = ((HttpEntityEnclosingRequest)request).getEntity()) != null && entity.getContentLength() != 0L) {
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            if (HttpProtocolParams.useExpectContinue(request.getParams()) && !ver.lessEquals(HttpVersion.HTTP_1_0)) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

