/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.google.protobuf;

import com.mathworks.google.protobuf.ByteString;
import com.mathworks.google.protobuf.LiteralByteString;
import java.util.NoSuchElementException;

class BoundedByteString
extends LiteralByteString {
    private final int bytesOffset;
    private final int bytesLength;

    BoundedByteString(byte[] byArray, int n, int n2) {
        super(byArray);
        if (n < 0) {
            throw new IllegalArgumentException("Offset too small: " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Length too small: " + n);
        }
        if ((long)n + (long)n2 > (long)byArray.length) {
            throw new IllegalArgumentException("Offset+Length too large: " + n + "+" + n2);
        }
        this.bytesOffset = n;
        this.bytesLength = n2;
    }

    public byte byteAt(int n) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("Index too small: " + n);
        }
        if (n >= this.size()) {
            throw new ArrayIndexOutOfBoundsException("Index too large: " + n + ", " + this.size());
        }
        return this.bytes[this.bytesOffset + n];
    }

    public int size() {
        return this.bytesLength;
    }

    protected int getOffsetIntoBytes() {
        return this.bytesOffset;
    }

    protected void copyToInternal(byte[] byArray, int n, int n2, int n3) {
        System.arraycopy(this.bytes, this.getOffsetIntoBytes() + n, byArray, n2, n3);
    }

    public ByteString.ByteIterator iterator() {
        return new BoundedByteIterator();
    }

    private class BoundedByteIterator
    implements ByteString.ByteIterator {
        private int position;
        private final int limit;

        private BoundedByteIterator() {
            this.position = BoundedByteString.this.getOffsetIntoBytes();
            this.limit = this.position + BoundedByteString.this.size();
        }

        public boolean hasNext() {
            return this.position < this.limit;
        }

        public Byte next() {
            return this.nextByte();
        }

        public byte nextByte() {
            if (this.position >= this.limit) {
                throw new NoSuchElementException();
            }
            return BoundedByteString.this.bytes[this.position++];
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

