/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.google.protobuf;

import com.mathworks.google.protobuf.BoundedByteString;
import com.mathworks.google.protobuf.ByteString;
import com.mathworks.google.protobuf.CodedInputStream;
import com.mathworks.google.protobuf.RopeByteString;
import com.mathworks.google.protobuf.Utf8;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LiteralByteString
extends ByteString {
    protected final byte[] bytes;
    private int hash = 0;

    LiteralByteString(byte[] byArray) {
        this.bytes = byArray;
    }

    @Override
    public byte byteAt(int n) {
        return this.bytes[n];
    }

    @Override
    public int size() {
        return this.bytes.length;
    }

    @Override
    public ByteString substring(int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Beginning index: " + n + " < 0");
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("End index: " + n2 + " > " + this.size());
        }
        int n3 = n2 - n;
        if (n3 < 0) {
            throw new IndexOutOfBoundsException("Beginning index larger than ending index: " + n + ", " + n2);
        }
        ByteString byteString = n3 == 0 ? ByteString.EMPTY : new BoundedByteString(this.bytes, this.getOffsetIntoBytes() + n, n3);
        return byteString;
    }

    @Override
    protected void copyToInternal(byte[] byArray, int n, int n2, int n3) {
        System.arraycopy(this.bytes, n, byArray, n2, n3);
    }

    @Override
    public void copyTo(ByteBuffer byteBuffer) {
        byteBuffer.put(this.bytes, this.getOffsetIntoBytes(), this.size());
    }

    @Override
    public ByteBuffer asReadOnlyByteBuffer() {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.bytes, this.getOffsetIntoBytes(), this.size());
        return byteBuffer.asReadOnlyBuffer();
    }

    @Override
    public List<ByteBuffer> asReadOnlyByteBufferList() {
        ArrayList<ByteBuffer> arrayList = new ArrayList<ByteBuffer>(1);
        arrayList.add(this.asReadOnlyByteBuffer());
        return arrayList;
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.toByteArray());
    }

    @Override
    public String toString(String string) throws UnsupportedEncodingException {
        return new String(this.bytes, this.getOffsetIntoBytes(), this.size(), string);
    }

    @Override
    public boolean isValidUtf8() {
        int n = this.getOffsetIntoBytes();
        return Utf8.isValidUtf8(this.bytes, n, n + this.size());
    }

    @Override
    protected int partialIsValidUtf8(int n, int n2, int n3) {
        int n4 = this.getOffsetIntoBytes() + n2;
        return Utf8.partialIsValidUtf8(n, this.bytes, n4, n4 + n3);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ByteString)) {
            return false;
        }
        if (this.size() != ((ByteString)object).size()) {
            return false;
        }
        if (this.size() == 0) {
            return true;
        }
        if (object instanceof LiteralByteString) {
            return this.equalsRange((LiteralByteString)object, 0, this.size());
        }
        if (object instanceof RopeByteString) {
            return object.equals(this);
        }
        throw new IllegalArgumentException("Has a new type of ByteString been created? Found " + object.getClass());
    }

    boolean equalsRange(LiteralByteString literalByteString, int n, int n2) {
        if (n2 > literalByteString.size()) {
            throw new IllegalArgumentException("Length too large: " + n2 + this.size());
        }
        if (n + n2 > literalByteString.size()) {
            throw new IllegalArgumentException("Ran off end of other: " + n + ", " + n2 + ", " + literalByteString.size());
        }
        byte[] byArray = this.bytes;
        byte[] byArray2 = literalByteString.bytes;
        int n3 = this.getOffsetIntoBytes() + n2;
        int n4 = this.getOffsetIntoBytes();
        int n5 = literalByteString.getOffsetIntoBytes() + n;
        while (n4 < n3) {
            if (byArray[n4] != byArray2[n5]) {
                return false;
            }
            ++n4;
            ++n5;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = this.hash;
        if (n == 0) {
            int n2 = this.size();
            n = this.partialHash(n2, 0, n2);
            if (n == 0) {
                n = 1;
            }
            this.hash = n;
        }
        return n;
    }

    @Override
    protected int peekCachedHashCode() {
        return this.hash;
    }

    @Override
    protected int partialHash(int n, int n2, int n3) {
        int n4;
        byte[] byArray = this.bytes;
        int n5 = n4 + n3;
        for (n4 = this.getOffsetIntoBytes() + n2; n4 < n5; ++n4) {
            n = n * 31 + byArray[n4];
        }
        return n;
    }

    @Override
    public InputStream newInput() {
        return new ByteArrayInputStream(this.bytes, this.getOffsetIntoBytes(), this.size());
    }

    @Override
    public CodedInputStream newCodedInput() {
        return CodedInputStream.newInstance(this.bytes, this.getOffsetIntoBytes(), this.size());
    }

    @Override
    public ByteString.ByteIterator iterator() {
        return new LiteralByteIterator();
    }

    @Override
    protected int getTreeDepth() {
        return 0;
    }

    @Override
    protected boolean isBalanced() {
        return true;
    }

    protected int getOffsetIntoBytes() {
        return 0;
    }

    private class LiteralByteIterator
    implements ByteString.ByteIterator {
        private int position = 0;
        private final int limit;

        private LiteralByteIterator() {
            this.limit = LiteralByteString.this.size();
        }

        public boolean hasNext() {
            return this.position < this.limit;
        }

        public Byte next() {
            return this.nextByte();
        }

        public byte nextByte() {
            try {
                return LiteralByteString.this.bytes[this.position++];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new NoSuchElementException(arrayIndexOutOfBoundsException.getMessage());
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

