/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.google.protobuf;

import com.mathworks.google.protobuf.FieldSet;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SmallSortedMap<K extends Comparable<K>, V>
extends AbstractMap<K, V> {
    private final int maxArraySize;
    private List<Entry> entryList;
    private Map<K, V> overflowEntries;
    private boolean isImmutable;
    private volatile EntrySet lazyEntrySet;

    static <FieldDescriptorType extends FieldSet.FieldDescriptorLite<FieldDescriptorType>> SmallSortedMap<FieldDescriptorType, Object> newFieldMap(int n) {
        return new SmallSortedMap<FieldDescriptorType, Object>(n){

            @Override
            public void makeImmutable() {
                if (!this.isImmutable()) {
                    List list;
                    for (int i = 0; i < this.getNumArrayEntries(); ++i) {
                        Map.Entry entry = this.getArrayEntryAt(i);
                        if (!((FieldSet.FieldDescriptorLite)entry.getKey()).isRepeated()) continue;
                        list = (List)entry.getValue();
                        entry.setValue(Collections.unmodifiableList(list));
                    }
                    for (Map.Entry entry : this.getOverflowEntries()) {
                        if (!((FieldSet.FieldDescriptorLite)entry.getKey()).isRepeated()) continue;
                        list = (List)entry.getValue();
                        entry.setValue(Collections.unmodifiableList(list));
                    }
                }
                super.makeImmutable();
            }
        };
    }

    static <K extends Comparable<K>, V> SmallSortedMap<K, V> newInstanceForTest(int n) {
        return new SmallSortedMap<K, V>(n);
    }

    private SmallSortedMap(int n) {
        this.maxArraySize = n;
        this.entryList = Collections.emptyList();
        this.overflowEntries = Collections.emptyMap();
    }

    public void makeImmutable() {
        if (!this.isImmutable) {
            this.overflowEntries = this.overflowEntries.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(this.overflowEntries);
            this.isImmutable = true;
        }
    }

    public boolean isImmutable() {
        return this.isImmutable;
    }

    public int getNumArrayEntries() {
        return this.entryList.size();
    }

    public Map.Entry<K, V> getArrayEntryAt(int n) {
        return this.entryList.get(n);
    }

    public int getNumOverflowEntries() {
        return this.overflowEntries.size();
    }

    public Iterable<Map.Entry<K, V>> getOverflowEntries() {
        return this.overflowEntries.isEmpty() ? EmptySet.iterable() : this.overflowEntries.entrySet();
    }

    @Override
    public int size() {
        return this.entryList.size() + this.overflowEntries.size();
    }

    @Override
    public boolean containsKey(Object object) {
        Comparable comparable = (Comparable)object;
        return this.binarySearchInArray(comparable) >= 0 || this.overflowEntries.containsKey(comparable);
    }

    @Override
    public V get(Object object) {
        Comparable comparable = (Comparable)object;
        int n = this.binarySearchInArray(comparable);
        if (n >= 0) {
            return this.entryList.get(n).getValue();
        }
        return this.overflowEntries.get(comparable);
    }

    @Override
    public V put(K k, V v) {
        this.checkMutable();
        int n = this.binarySearchInArray(k);
        if (n >= 0) {
            return this.entryList.get(n).setValue(v);
        }
        this.ensureEntryArrayMutable();
        int n2 = -(n + 1);
        if (n2 >= this.maxArraySize) {
            return this.getOverflowEntriesMutable().put(k, v);
        }
        if (this.entryList.size() == this.maxArraySize) {
            Entry entry = this.entryList.remove(this.maxArraySize - 1);
            this.getOverflowEntriesMutable().put(entry.getKey(), entry.getValue());
        }
        this.entryList.add(n2, new Entry(this, k, v));
        return null;
    }

    @Override
    public void clear() {
        this.checkMutable();
        if (!this.entryList.isEmpty()) {
            this.entryList.clear();
        }
        if (!this.overflowEntries.isEmpty()) {
            this.overflowEntries.clear();
        }
    }

    @Override
    public V remove(Object object) {
        this.checkMutable();
        Comparable comparable = (Comparable)object;
        int n = this.binarySearchInArray(comparable);
        if (n >= 0) {
            return this.removeArrayEntryAt(n);
        }
        if (this.overflowEntries.isEmpty()) {
            return null;
        }
        return this.overflowEntries.remove(comparable);
    }

    private V removeArrayEntryAt(int n) {
        this.checkMutable();
        Object v = this.entryList.remove(n).getValue();
        if (!this.overflowEntries.isEmpty()) {
            Iterator<Map.Entry<K, V>> iterator = this.getOverflowEntriesMutable().entrySet().iterator();
            this.entryList.add(new Entry(this, iterator.next()));
            iterator.remove();
        }
        return v;
    }

    private int binarySearchInArray(K k) {
        int n;
        int n2 = 0;
        int n3 = this.entryList.size() - 1;
        if (n3 >= 0) {
            n = k.compareTo((Object)this.entryList.get(n3).getKey());
            if (n > 0) {
                return -(n3 + 2);
            }
            if (n == 0) {
                return n3;
            }
        }
        while (n2 <= n3) {
            n = (n2 + n3) / 2;
            int n4 = k.compareTo((Object)this.entryList.get(n).getKey());
            if (n4 < 0) {
                n3 = n - 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n + 1;
                continue;
            }
            return n;
        }
        return -(n2 + 1);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.lazyEntrySet == null) {
            this.lazyEntrySet = new EntrySet();
        }
        return this.lazyEntrySet;
    }

    private void checkMutable() {
        if (this.isImmutable) {
            throw new UnsupportedOperationException();
        }
    }

    private SortedMap<K, V> getOverflowEntriesMutable() {
        this.checkMutable();
        if (this.overflowEntries.isEmpty() && !(this.overflowEntries instanceof TreeMap)) {
            this.overflowEntries = new TreeMap();
        }
        return (SortedMap)this.overflowEntries;
    }

    private void ensureEntryArrayMutable() {
        this.checkMutable();
        if (this.entryList.isEmpty() && !(this.entryList instanceof ArrayList)) {
            this.entryList = new ArrayList<Entry>(this.maxArraySize);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptySet {
        private static final Iterator<Object> ITERATOR = new Iterator<Object>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public Object next() {
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        private static final Iterable<Object> ITERABLE = new Iterable<Object>(){

            @Override
            public Iterator<Object> iterator() {
                return ITERATOR;
            }
        };

        private EmptySet() {
        }

        static <T> Iterable<T> iterable() {
            return ITERABLE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private int pos = -1;
        private boolean nextCalledBeforeRemove;
        private Iterator<Map.Entry<K, V>> lazyOverflowIterator;

        private EntryIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pos + 1 < SmallSortedMap.this.entryList.size() || this.getOverflowIterator().hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            this.nextCalledBeforeRemove = true;
            if (++this.pos < SmallSortedMap.this.entryList.size()) {
                return (Map.Entry)SmallSortedMap.this.entryList.get(this.pos);
            }
            return this.getOverflowIterator().next();
        }

        @Override
        public void remove() {
            if (!this.nextCalledBeforeRemove) {
                throw new IllegalStateException("remove() was called before next()");
            }
            this.nextCalledBeforeRemove = false;
            SmallSortedMap.this.checkMutable();
            if (this.pos < SmallSortedMap.this.entryList.size()) {
                SmallSortedMap.this.removeArrayEntryAt(this.pos--);
            } else {
                this.getOverflowIterator().remove();
            }
        }

        private Iterator<Map.Entry<K, V>> getOverflowIterator() {
            if (this.lazyOverflowIterator == null) {
                this.lazyOverflowIterator = SmallSortedMap.this.overflowEntries.entrySet().iterator();
            }
            return this.lazyOverflowIterator;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public int size() {
            return SmallSortedMap.this.size();
        }

        @Override
        public boolean contains(Object object) {
            Object v;
            Map.Entry entry = (Map.Entry)object;
            Object v2 = SmallSortedMap.this.get(entry.getKey());
            return v2 == (v = entry.getValue()) || v2 != null && v2.equals(v);
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            if (!this.contains(entry)) {
                SmallSortedMap.this.put((Comparable)entry.getKey(), entry.getValue());
                return true;
            }
            return false;
        }

        @Override
        public boolean remove(Object object) {
            Map.Entry entry = (Map.Entry)object;
            if (this.contains(entry)) {
                SmallSortedMap.this.remove(entry.getKey());
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            SmallSortedMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry
    implements Map.Entry<K, V>,
    Comparable<Entry> {
        private final K key;
        private V value;
        final /* synthetic */ SmallSortedMap this$0;

        Entry(SmallSortedMap smallSortedMap, Map.Entry<K, V> entry) {
            this(smallSortedMap, (Comparable)entry.getKey(), entry.getValue());
        }

        Entry(K k, V v) {
            this.this$0 = var1_1;
            this.key = k;
            this.value = v;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public int compareTo(Entry entry) {
            return this.getKey().compareTo(entry.getKey());
        }

        @Override
        public V setValue(V v) {
            this.this$0.checkMutable();
            Object v2 = this.value;
            this.value = v;
            return v2;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return this.equals(this.key, entry.getKey()) && this.equals(this.value, entry.getValue());
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        private boolean equals(Object object, Object object2) {
            return object == null ? object2 == null : object.equals(object2);
        }
    }
}

