/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal;

import com.mathworks.apache.http.HttpResponse;
import com.mathworks.apache.http.client.methods.HttpPost;
import com.mathworks.apache.http.conn.ssl.AbstractVerifier;
import com.mathworks.apache.http.entity.ByteArrayEntity;
import com.mathworks.apache.http.impl.nio.client.DefaultHttpAsyncClient;
import com.mathworks.apache.http.impl.nio.conn.PoolingClientAsyncConnectionManager;
import com.mathworks.apache.http.nio.client.HttpAsyncClient;
import com.mathworks.apache.http.nio.conn.scheme.AsyncScheme;
import com.mathworks.apache.http.nio.conn.scheme.AsyncSchemeRegistry;
import com.mathworks.apache.http.nio.conn.ssl.SSLLayeringStrategy;
import com.mathworks.apache.http.nio.reactor.IOSession;
import com.mathworks.apache.http.nio.reactor.ssl.SSLIOSession;
import com.mathworks.apache.http.nio.reactor.ssl.SSLMode;
import com.mathworks.apache.http.nio.reactor.ssl.SSLSetupHandler;
import com.mathworks.apache.http.params.HttpParams;
import com.mathworks.google.protobuf.CodedInputStream;
import com.mathworks.google.protobuf.ExtensionRegistryLite;
import com.mathworks.mps.client.MWHttpClientConfig;
import com.mathworks.mps.client.MWHttpException;
import com.mathworks.mps.client.MWSSLConfig;
import com.mathworks.mps.client.internal.AbstractHttpClientFevalHandler;
import com.mathworks.mps.client.internal.MATLABParams;
import com.mathworks.mps.client.internal.MATLABResult;
import com.mathworks.mps.client.internal.MWInvocationHandlerUtils;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public class ApacheHttpClientFevalHandler
extends AbstractHttpClientFevalHandler {
    private final HttpAsyncClient httpClientAsync;
    private final AbstractVerifier defaultHostnameVerifier = new AbstractVerifier(){

        public final void verify(String string, String[] stringArray, String[] stringArray2) throws SSLException {
            this.verify(string, stringArray, stringArray2, false);
        }
    };

    public ApacheHttpClientFevalHandler(MWHttpClientConfig mWHttpClientConfig, MWSSLConfig mWSSLConfig) {
        super(mWHttpClientConfig.getResponseSizeLimit());
        try {
            this.httpClientAsync = new DefaultHttpAsyncClient();
            PoolingClientAsyncConnectionManager poolingClientAsyncConnectionManager = (PoolingClientAsyncConnectionManager)this.httpClientAsync.getConnectionManager();
            this.configureHttpClientConnection(poolingClientAsyncConnectionManager, mWHttpClientConfig);
            this.configureHttpClientSSL(poolingClientAsyncConnectionManager, mWSSLConfig);
            this.httpClientAsync.start();
        }
        catch (Exception exception) {
            throw new RuntimeException("Trouble initializing MWHttpClient", exception);
        }
    }

    private void configureHttpClientConnection(PoolingClientAsyncConnectionManager poolingClientAsyncConnectionManager, MWHttpClientConfig mWHttpClientConfig) {
        poolingClientAsyncConnectionManager.setDefaultMaxPerRoute(mWHttpClientConfig.getMaxConnectionsPerAddress());
        HttpParams httpParams = this.httpClientAsync.getParams();
        httpParams.setIntParameter("http.socket.timeout", (int)mWHttpClientConfig.getTimeOutMs());
        httpParams.setBooleanParameter("http.tcp.nodelay", false);
        httpParams.setParameter("http.useragent", ApacheHttpClientFevalHandler.class.getName());
    }

    private void configureHttpClientSSL(PoolingClientAsyncConnectionManager poolingClientAsyncConnectionManager, final MWSSLConfig mWSSLConfig) throws Exception {
        final SSLContext sSLContext = mWSSLConfig.getSSLContext() == null ? SSLContext.getDefault() : mWSSLConfig.getSSLContext();
        final SSLSetupHandler sSLSetupHandler = new SSLSetupHandler(){

            public void initalize(SSLEngine sSLEngine) throws SSLException {
            }

            public void verify(IOSession iOSession, SSLSession sSLSession) throws SSLException {
                ApacheHttpClientFevalHandler.this.verifySSLSession(iOSession, sSLSession, mWSSLConfig);
            }
        };
        SSLLayeringStrategy sSLLayeringStrategy = new SSLLayeringStrategy(sSLContext){

            public SSLIOSession layer(IOSession iOSession) {
                SSLIOSession sSLIOSession = new SSLIOSession(iOSession, SSLMode.CLIENT, sSLContext, sSLSetupHandler);
                iOSession.setAttribute("http.session.ssl", sSLIOSession);
                return sSLIOSession;
            }
        };
        AsyncScheme asyncScheme = new AsyncScheme("https", 443, sSLLayeringStrategy);
        AsyncSchemeRegistry asyncSchemeRegistry = poolingClientAsyncConnectionManager.getSchemeRegistry();
        asyncSchemeRegistry.register(asyncScheme);
    }

    private void verifySSLSession(IOSession iOSession, SSLSession sSLSession, MWSSLConfig mWSSLConfig) throws SSLException {
        block3: {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)iOSession.getRemoteAddress();
            try {
                Certificate[] certificateArray = sSLSession.getPeerCertificates();
                if (certificateArray.length <= 0 || !(certificateArray[0] instanceof X509Certificate)) {
                    throw new SSLPeerUnverifiedException("No X509 certificate provided by the peer");
                }
                X509Certificate x509Certificate = (X509Certificate)certificateArray[0];
                this.defaultHostnameVerifier.verify(inetSocketAddress.getHostName(), x509Certificate);
            }
            catch (SSLException sSLException) {
                HostnameVerifier hostnameVerifier = mWSSLConfig.getHostnameVerifier();
                if (hostnameVerifier != null && hostnameVerifier.verify(inetSocketAddress.getHostName(), sSLSession)) break block3;
                throw sSLException;
            }
        }
        MWInvocationHandlerUtils.throwIfServerIsNotAuthorized(sSLSession.getPeerCertificates(), mWSSLConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MATLABResult.MATLAB_Result processRequest(URL uRL, MATLABParams.MATLAB_Params mATLAB_Params) throws Throwable {
        MATLABResult.MATLAB_Result mATLAB_Result;
        HttpPost httpPost = new HttpPost(uRL.toString());
        httpPost.addHeader("Content-Type", "application/x-google-protobuf");
        httpPost.setEntity(new ByteArrayEntity(mATLAB_Params.toByteArray()));
        Future<HttpResponse> future = this.httpClientAsync.execute(httpPost, null);
        HttpResponse httpResponse = future.get();
        int n = httpResponse.getStatusLine().getStatusCode();
        if (n != 200) throw new MWHttpException(n, httpResponse.getStatusLine().getReasonPhrase());
        InputStream inputStream = httpResponse.getEntity().getContent();
        try {
            CodedInputStream codedInputStream = CodedInputStream.newInstance(inputStream);
            codedInputStream.setSizeLimit(this.responseSizeLimit);
            mATLAB_Result = MATLABResult.MATLAB_Result.parseFrom(codedInputStream, (ExtensionRegistryLite)MWInvocationHandlerUtils.extRegistry);
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (ExecutionException executionException) {
                throw executionException.getCause();
            }
        }
        inputStream.close();
        return mATLAB_Result;
    }

    public void close() {
        if (!this.closed) {
            super.close();
            try {
                this.httpClientAsync.shutdown();
            }
            catch (Exception exception) {
                throw new RuntimeException("Trouble closing MWHttpClient", exception);
            }
        }
    }
}

