/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal;

import com.mathworks.mps.client.MATLABException;
import com.mathworks.mps.client.MWDefaultMarshalingRules;
import com.mathworks.mps.client.MWInvokable;
import com.mathworks.mps.client.MWMarshalingRules;
import com.mathworks.mps.client.internal.MATLABError;
import com.mathworks.mps.client.internal.MATLABParams;
import com.mathworks.mps.client.internal.MATLABResult;
import com.mathworks.mps.client.internal.MWAttributesContainer;
import com.mathworks.mps.client.internal.MWClientUsageLock;
import com.mathworks.mps.client.internal.MWFevalHandler;
import com.mathworks.mps.client.internal.MWInvocationHandlerUtils;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentProxy
implements MWInvokable {
    private final MWFevalHandler fevalHandler;
    private final URL componentURL;
    private final MWAttributesContainer attributesContainer;
    private final MWClientUsageLock mwClientUsageLock;

    public ComponentProxy(MWFevalHandler mWFevalHandler, URL uRL, MWMarshalingRules mWMarshalingRules, MWClientUsageLock mWClientUsageLock) {
        this.fevalHandler = mWFevalHandler;
        this.componentURL = uRL;
        this.attributesContainer = new MWAttributesContainer(mWMarshalingRules);
        this.mwClientUsageLock = mWClientUsageLock;
    }

    public ComponentProxy(MWFevalHandler mWFevalHandler, URL uRL, MWClientUsageLock mWClientUsageLock) {
        this.fevalHandler = mWFevalHandler;
        this.componentURL = uRL;
        this.attributesContainer = new MWAttributesContainer(new MWDefaultMarshalingRules());
        this.mwClientUsageLock = mWClientUsageLock;
    }

    @Override
    public <T> T invoke(String string, int n, Class<T> clazz, Object ... objectArray) throws Throwable {
        return this.processRequest(string, n, clazz, true, objectArray);
    }

    private <T> T processRequest(String string, int n, Class<T> clazz, boolean bl, Object ... objectArray) throws Throwable {
        this.mwClientUsageLock.usageEnter("MWHttpClient that provided the proxy object has already been closed");
        try {
            if (n > 1 && clazz != Object[].class) {
                throw new IllegalArgumentException("targetType must be Object[] if nargout value is greater than 1");
            }
            MATLABParams.MATLAB_Params mATLAB_Params = MWInvocationHandlerUtils.createMATLABParams(n, objectArray, this.attributesContainer);
            MATLABResult.MATLAB_Result mATLAB_Result = this.fevalHandler.processRequest(new URL(this.componentURL.toString() + "/" + string), mATLAB_Params);
            this.checkMLResultForErrors(string, mATLAB_Params, mATLAB_Result);
            Object object = MWInvocationHandlerUtils.createMATLABResponse(clazz, n, mATLAB_Result, bl, this.attributesContainer);
            return (T)object;
        }
        finally {
            this.mwClientUsageLock.usageExit();
        }
    }

    @Override
    public <T> T invoke(String string, Class<T> clazz, Object ... objectArray) throws Throwable {
        return this.processRequest(string, 1, clazz, false, objectArray);
    }

    @Override
    public void invokeVoid(String string, Object ... objectArray) throws Throwable {
        this.processRequest(string, 0, Void.TYPE, false, objectArray);
    }

    private void checkMLResultForErrors(String string, MATLABParams.MATLAB_Params mATLAB_Params, MATLABResult.MATLAB_Result mATLAB_Result) throws MATLABException {
        if (!mATLAB_Result.hasError()) {
            if (mATLAB_Result.getLhsCount() != mATLAB_Params.getNargout()) {
                throw new IllegalArgumentException("Incorrect number of outputs returned from MATLAB.\nMATLAB returned " + mATLAB_Result.getLhsCount() + " number of outputs,\n" + "Method ," + string + ", expected " + mATLAB_Params.getNargout() + " number of outputs.");
            }
        } else {
            MATLABError.MATLAB_Error mATLAB_Error = mATLAB_Result.getError();
            throw new MATLABException(mATLAB_Error.getMessage(), mATLAB_Error.getIdentifier(), MWInvocationHandlerUtils.convertToMATLABStackFrameList(mATLAB_Error.getStackList()));
        }
    }
}

