/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal;

import com.mathworks.mps.client.MWClient;
import com.mathworks.mps.client.MWInvokable;
import com.mathworks.mps.client.MWMarshalingRules;
import com.mathworks.mps.client.annotations.MWStructureList;
import com.mathworks.mps.client.internal.AbstractMethodDispatcher;
import com.mathworks.mps.client.internal.MWMethodDispatcher;
import com.mathworks.mps.client.internal.NargoutDispatcher;
import com.mathworks.mps.client.internal.SingleOutputDispatcher;
import com.mathworks.mps.client.internal.VoidOutputDispatcher;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentifyDispatcher {
    public static Map<Method, MWMethodDispatcher> buildMethodToDispatcherMap(URL uRL, Class clazz, MWClient mWClient) {
        List<Class> list = IdentifyDispatcher.getInterfaceStructAttribute(clazz);
        Method[] methodArray = clazz.getDeclaredMethods();
        HashMap<Method, AbstractMethodDispatcher> hashMap = new HashMap<Method, AbstractMethodDispatcher>();
        for (Method method : methodArray) {
            List<Class> list2 = IdentifyDispatcher.getMethodStructAttribute(method);
            MWMarshalingRules mWMarshalingRules = IdentifyDispatcher.createMarshalingRules(list, list2);
            MWInvokable mWInvokable = mWClient.createComponentProxy(uRL, mWMarshalingRules);
            boolean bl = IdentifyDispatcher.checkForNargout(method);
            boolean bl2 = method.isVarArgs();
            if (bl) {
                hashMap.put(method, new NargoutDispatcher(method.getName(), mWInvokable, bl2));
                continue;
            }
            if (method.getReturnType().equals(Void.TYPE)) {
                hashMap.put(method, new VoidOutputDispatcher(method.getName(), mWInvokable, bl2));
                continue;
            }
            hashMap.put(method, new SingleOutputDispatcher(method.getName(), method.getReturnType(), mWInvokable, bl2));
        }
        return Collections.unmodifiableMap(hashMap);
    }

    private static MWMarshalingRules createMarshalingRules(List<Class> list, List<Class> list2) {
        final ArrayList<Class> arrayList = new ArrayList<Class>(list.size() + list2.size());
        for (Class clazz : list2) {
            arrayList.add(clazz);
        }
        for (Class clazz : list) {
            arrayList.add(clazz);
        }
        return new MWMarshalingRules(){

            @Override
            public List<Class> getStructTypes() {
                return arrayList;
            }
        };
    }

    private static List<Class> getInterfaceStructAttribute(Class clazz) {
        ArrayList<Class> arrayList;
        MWStructureList mWStructureList = clazz.getAnnotation(MWStructureList.class);
        ArrayList<Class> arrayList2 = arrayList = mWStructureList != null ? new ArrayList<Class>(mWStructureList.value().length) : new ArrayList();
        if (mWStructureList != null) {
            arrayList.addAll(Arrays.asList(mWStructureList.value()));
        }
        return Collections.unmodifiableList(arrayList);
    }

    private static List<Class> getMethodStructAttribute(Method method) {
        ArrayList<Class> arrayList;
        MWStructureList mWStructureList = method.getAnnotation(MWStructureList.class);
        ArrayList<Class> arrayList2 = arrayList = mWStructureList != null ? new ArrayList<Class>(mWStructureList.value().length) : new ArrayList();
        if (mWStructureList != null) {
            arrayList.addAll(Arrays.asList(mWStructureList.value()));
        }
        return Collections.unmodifiableList(arrayList);
    }

    private static boolean checkForNargout(Method method) {
        Class<?> clazz = method.getReturnType();
        Class<?>[] classArray = method.getParameterTypes();
        return clazz.equals(Object[].class) && classArray.length > 0 && classArray[0] == Integer.TYPE;
    }
}

