/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal;

import com.mathworks.mps.client.MATLABException;
import com.mathworks.mps.client.annotations.MWStructureList;
import com.mathworks.mps.client.internal.ArrayUtils;
import com.mathworks.mps.client.internal.MWStructToBeanFactory;
import com.mathworks.mps.client.internal.MWStructToBeanFactoryConstructor;
import com.mathworks.mps.client.internal.MWStructToBeanFactoryMaker;
import com.mathworks.mps.client.internal.MWStructToBeanFactorySetter;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceValidator {
    private static final Collection<Class<? extends Exception>> requiredExceptions = Collections.unmodifiableCollection(Arrays.asList(IOException.class, MATLABException.class));
    private static final String requiredExceptionsString = requiredExceptions.toString().replaceAll("class", "");
    private static final Collection<Class> supportedJavaTypes = InterfaceValidator.initializeSupportedJavaTypesSet();

    private static Collection<Class> initializeSupportedJavaTypesSet() {
        HashSet<Class> hashSet = new HashSet<Class>();
        hashSet.add(Byte.TYPE);
        hashSet.add(Byte.class);
        hashSet.add(Short.TYPE);
        hashSet.add(Short.class);
        hashSet.add(Integer.TYPE);
        hashSet.add(Integer.class);
        hashSet.add(Long.TYPE);
        hashSet.add(Long.class);
        hashSet.add(Float.TYPE);
        hashSet.add(Float.class);
        hashSet.add(Double.TYPE);
        hashSet.add(Double.class);
        hashSet.add(Character.TYPE);
        hashSet.add(Character.class);
        hashSet.add(Boolean.TYPE);
        hashSet.add(Boolean.class);
        hashSet.add(String.class);
        hashSet.add(Object.class);
        hashSet.add(Void.TYPE);
        return Collections.unmodifiableSet(hashSet);
    }

    public static void validateInterface(Class clazz) {
        ArrayList<Class> arrayList = new ArrayList<Class>();
        ArrayList<Class> arrayList2 = new ArrayList<Class>();
        Collection<Class> collection = InterfaceValidator.getMWStructListAnnotationValue(clazz);
        InterfaceValidator.validateStructAnnotation(collection, arrayList, arrayList2);
        Method[] methodArray = clazz.getDeclaredMethods();
        if (methodArray.length == 0) {
            throw new IllegalArgumentException("Interface must have at least one method");
        }
        for (Method method : methodArray) {
            Class<?>[] classArray;
            Object object;
            if (!InterfaceValidator.throwsAllCheckedExceptions(method)) {
                object = "Method \"" + method.getName() + "\" and all the other methods of interface \"" + clazz.getName() + "\" must throw following checked exceptions :\n" + requiredExceptionsString + "\n";
                throw new IllegalArgumentException((String)object);
            }
            object = InterfaceValidator.getMWStructListAnnotationValue(method);
            InterfaceValidator.validateStructAnnotation(object, arrayList, arrayList2);
            object.addAll(collection);
            for (Class<?> clazz2 : classArray = method.getParameterTypes()) {
                if (InterfaceValidator.isValidAsInputParameter(clazz2, (Collection<Class>)object, arrayList)) continue;
                throw new IllegalArgumentException(InterfaceValidator.getErrorMsgForInvalidInputs(clazz2.getName(), method.getName(), method.getDeclaringClass().getName()));
            }
            if (InterfaceValidator.isValidAsOutputParameter(method.getReturnType(), (Collection<Class>)object, arrayList2)) continue;
            throw new IllegalArgumentException(InterfaceValidator.getErrorMsgForInvalidOutput(method.getName(), method.getDeclaringClass().getName()));
        }
    }

    private static boolean throwsAllCheckedExceptions(Method method) {
        Class[] classArray = method.getExceptionTypes();
        if (classArray.length == 0) {
            return false;
        }
        for (Class<? extends Exception> clazz : requiredExceptions) {
            if (InterfaceValidator.isAssignableFrom(classArray, clazz)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidAsInputParameter(Class clazz, Collection<Class> collection, List<Class> list) {
        Class clazz2 = ArrayUtils.getArrayElementType(clazz);
        return supportedJavaTypes.contains(clazz2) || collection.contains(clazz2) && InterfaceValidator.isValidInputAsStructure(clazz2, list);
    }

    private static boolean isValidAsOutputParameter(Class clazz, Collection<Class> collection, List<Class> list) {
        Class clazz2 = ArrayUtils.getArrayElementType(clazz);
        return supportedJavaTypes.contains(clazz2) || collection.contains(clazz2) && InterfaceValidator.isValidOutputAsStructure(clazz2, list);
    }

    private static void validateStructAnnotation(Collection<Class> collection, List<Class> list, List<Class> list2) {
        for (Class clazz : collection) {
            InterfaceValidator.throwIfArrayType(clazz);
            if (InterfaceValidator.isValidInputAsStructure(clazz, list) || InterfaceValidator.isValidOutputAsStructure(clazz, list2)) continue;
            throw new IllegalArgumentException(InterfaceValidator.getErrorMsgForInvalidAnnotation(clazz.getName()));
        }
    }

    private static boolean isValidInputAsStructure(Class clazz, List<Class> list) {
        if (list.contains(clazz)) {
            return true;
        }
        Collection<Class> collection = InterfaceValidator.getMWStructListAnnotationValue(clazz);
        int n = 0;
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz, Object.class);
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            if (propertyDescriptorArray == null || propertyDescriptorArray.length == 0) {
                return false;
            }
            for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray) {
                Method method = propertyDescriptor.getReadMethod();
                if (method == null) continue;
                if (!list.contains(clazz)) {
                    list.add(clazz);
                }
                Collection<Class> collection2 = InterfaceValidator.getMWStructListAnnotationValue(method);
                collection2.addAll(collection);
                if (!InterfaceValidator.isValidAsInputParameter(propertyDescriptor.getPropertyType(), collection2, list)) {
                    return false;
                }
                ++n;
            }
        }
        catch (IntrospectionException introspectionException) {
            return false;
        }
        return n > 0;
    }

    private static boolean isValidOutputAsStructure(Class clazz, List<Class> list) {
        if (list.contains(clazz)) {
            return true;
        }
        Collection<Class> collection = InterfaceValidator.getMWStructListAnnotationValue(clazz);
        List<MWStructToBeanFactory> list2 = MWStructToBeanFactoryMaker.createFactoryList(clazz);
        if (list2.size() == 0) {
            return false;
        }
        for (MWStructToBeanFactory mWStructToBeanFactory : list2) {
            Object object;
            Collection<GenericDeclaration> collection2;
            Object object3;
            if (!list.contains(clazz)) {
                list.add(clazz);
            }
            if (mWStructToBeanFactory instanceof MWStructToBeanFactorySetter) {
                object3 = ((MWStructToBeanFactorySetter)mWStructToBeanFactory).getBeanSetterMap();
                collection2 = object3.values();
                for (Method method : collection2) {
                    object = InterfaceValidator.getMWStructListAnnotationValue(method);
                    object.addAll(collection);
                    if (InterfaceValidator.isValidAsOutputParameter(method.getParameterTypes()[0], (Collection<Class>)object, list)) continue;
                    return false;
                }
                continue;
            }
            if (!(mWStructToBeanFactory instanceof MWStructToBeanFactoryConstructor)) continue;
            object3 = ((MWStructToBeanFactoryConstructor)mWStructToBeanFactory).getBeanConstructor();
            collection2 = InterfaceValidator.getMWStructListAnnotationValue(object3);
            collection2.addAll(collection);
            Collection<Class> collection3 = mWStructToBeanFactory.getAllPropTypes();
            Iterator iterator = collection3.iterator();
            while (iterator.hasNext()) {
                object = (Class)iterator.next();
                if (InterfaceValidator.isValidAsOutputParameter((Class)object, collection2, list)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isAssignableFrom(Class[] classArray, Class clazz) {
        boolean bl = false;
        for (Class clazz2 : classArray) {
            if (!clazz2.isAssignableFrom(clazz)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static Collection<Class> getMWStructListAnnotationValue(Object object) {
        HashSet<Class> hashSet = new HashSet<Class>();
        MWStructureList mWStructureList = null;
        if (object instanceof Class) {
            mWStructureList = ((Class)object).getAnnotation(MWStructureList.class);
        } else if (object instanceof Method) {
            mWStructureList = ((Method)object).getAnnotation(MWStructureList.class);
        } else if (object instanceof Constructor) {
            mWStructureList = ((Constructor)object).getAnnotation(MWStructureList.class);
        }
        if (mWStructureList != null) {
            hashSet.addAll(Arrays.asList(mWStructureList.value()));
        }
        return hashSet;
    }

    private static void throwIfArrayType(Class clazz) {
        if (clazz.isArray()) {
            throw new IllegalArgumentException("Found an invalid type in MWStructureList annotation : " + clazz.getName() + ". Only scalar types are allowed.");
        }
    }

    private static String getErrorMsgForInvalidInputs(String string, String string2, String string3) {
        return String.format("One of the types, %s, found during analysis of inputs of method, %s, of interface, %s, is unsupported.\nThe declared type of input must be either a Java primitive or boxed type, or String or Object. If it is a user defined class to represent\na MATLAB structure, it must fulfill following:\n1. It must be included in the MWStructureList annotation of either the method or the interface\n2. It must have at least one property with a public get method to retrieve its value\n3. The declared types of these properties must be valid\nPlease refer the javadoc for more information on supported types", string, string2, string3);
    }

    private static String getErrorMsgForInvalidOutput(String string, String string2) {
        return String.format("The return type of method, %s, of interface, %s, is unsupported.\nThe declared type of output must be either a Java primitive, boxed type, String or Object. If it is a user defined class to represent\na MATLAB structure, it must fulfill following:\n1. It must be included in the MWStructureList annotation of either the interface or the method\n2. It must have at least one property representing a field of a MATLAB structure\n3. It must have a public default constructor and public set methods for its properties or a public constructor that initializes all the \n   properties and has @ConstructorProperties annotation\n4. A default (no-argument) constructor needs to be explicitly defined only if there is a user defined overloaded constructor provided for this type\n5. The declared types of these properties must be valid\n6. If the declared type of one of the properties of this class is representing a MATLAB struct, it must be included in the\n   MWStructureList annotation provided for the class or for the set method for the property or for the constructor with the @ConstructorProperties annotation.\nPlease refer the javadoc for more information on supported types", string, string2);
    }

    private static String getErrorMsgForInvalidAnnotation(String string) {
        return String.format("One of the members, %s, of MWStructureList annotation, is unsupported and\ncannot be used for marshaling a MATLAB structure either as input or output.\n\nTo be a valid input MATLAB structure, a java class must fulfill following:\n1. It must have at least one property with a public get method to retrieve its value\n2. The declared types of these properties must be valid\n3. If the declared type of one of the properties of this class is representing a MATLAB struct, it must be included in the\n   MWStructureList annotation provided for the class or for the get method for the property.\n\nTo be a valid output MATLAB structure, a java class must fulfill following:\n1. It must have at least one property representing a field of a MATLAB structure\n2. It must have a public default constructor and public set methods for its properties or a public constructor that initializes all the \n   properties and has @ConstructorProperties annotation\n3. The declared types of these properties must be valid\n4. If the declared type of one of the properties of this class is representing a MATLAB struct, it must be included in the\n   MWStructureList annotation provided for the class or for the set method for the property or for the constructor with the @ConstructorProperties annotation.\nPlease refer the javadoc for more information on supported types", string);
    }
}

