/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal;

import com.mathworks.mps.client.internal.ArrayNumericCoercionEnabler;
import com.mathworks.mps.client.internal.ArrayUtils;
import com.mathworks.mps.client.internal.Curler;
import com.mathworks.mps.client.internal.MATLABArray;
import com.mathworks.mps.client.internal.MWAttributesContainer;
import com.mathworks.mps.client.internal.MWStructInfo;
import com.mathworks.mps.client.internal.MWStructToBeanFactory;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.nio.BufferOverflowException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaDataExtractor {
    private static Map<Class, Method> targetTypeToScalarCoercionMethod;
    private static Map<Class, Method> targetTypeToArrayCoercionMethod;
    private static Map<MATLABArray.MATLAB_Array.MWType, List> directlyConvertibleTypesMap;
    private static Map<MATLABArray.MATLAB_Array.MWType, List> scalarCoercibleNumericTypesMap;
    private static Map<Class, Class> primitiveToArrayType;
    private static final String COMPLEX_DATA_ERR_MSG = "Complex data received from MATLAB is not supported";
    private final MWAttributesContainer mwAttributesContainer;

    public JavaDataExtractor(MWAttributesContainer mWAttributesContainer) {
        this.mwAttributesContainer = mWAttributesContainer;
    }

    public Object toJavaType(MATLABArray.MATLAB_Array mATLAB_Array, Class clazz) {
        return this.getmlArray(mATLAB_Array, clazz, Method.class);
    }

    private Object getmlArray(MATLABArray.MATLAB_Array mATLAB_Array, Class clazz, Class clazz2) {
        Map<MWStructInfo, MWStructToBeanFactory> map = this.mwAttributesContainer.getChildrenStructsForParentMLOutput(clazz2);
        MATLABArray.MATLAB_Array.MWType mWType = mATLAB_Array.getType();
        switch (mWType) {
            case SPARSE: {
                throw new RuntimeException("Currently, MATLAB sparse data type is not supported");
            }
            case STRUCT: {
                return this.MATLABArrayToJavaStruct(mATLAB_Array, clazz, map);
            }
            case CELL: {
                return this.MATLABArrayToJavaCell(mATLAB_Array, clazz, map);
            }
        }
        return JavaDataExtractor.MATLABArrayToJavaPrimitives(mATLAB_Array, clazz, mWType);
    }

    private static String coersionFailureMsg(MATLABArray.MATLAB_Array.MWType mWType, List<Long> list, Class clazz, int n) {
        return "Data returned from MATLAB had dimensions : " + list + " and type : " + mWType.toString().toLowerCase() + ".\n" + "Target Java type, " + clazz.getName() + ", has number of dimensions : " + n + ".\n" + "Failed to change the dimensions of data from MATLAB to match the number of dimensions of target Java type.";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object MATLABArrayToJavaStruct(MATLABArray.MATLAB_Array mATLAB_Array, Class clazz, Map<MWStructInfo, MWStructToBeanFactory> map) {
        int[] nArray;
        Object[] objectArray = this.convertStructToBeanArray(mATLAB_Array, map);
        ArrayList<Long> arrayList = new ArrayList<Long>(mATLAB_Array.getDimensionList());
        Class<?> clazz2 = objectArray.getClass().getComponentType();
        Class clazz3 = ArrayUtils.getArrayElementType(clazz);
        int n = ArrayUtils.getNumberOfDimensions(clazz);
        if (!clazz3.isAssignableFrom(clazz2)) throw new RuntimeException("Data type of output from MATLAB : " + clazz2.getName() + ", is un-assignable to type of data in Java : " + clazz3.getName());
        if (arrayList.contains(0L)) {
            return null;
        }
        if (clazz3 != Object.class) {
            if (!ArrayUtils.coerceDimsList(arrayList, n)) {
                throw new RuntimeException(JavaDataExtractor.coersionFailureMsg(mATLAB_Array.getType(), mATLAB_Array.getDimensionList(), clazz3, n));
            }
        } else {
            if (clazz != Object.class) throw new RuntimeException("A MATLAB array of type structure cannot be marshaled into an Object array with, " + n + ", number of dimensions");
            ArrayUtils.coerceDimsList(arrayList, 0);
        }
        if ((nArray = ArrayUtils.toIntArray(arrayList.toArray(new Long[arrayList.size()]))).length != 0) return Curler.curl(objectArray, nArray);
        return objectArray[0];
    }

    public Object MATLABArrayToJavaCell(MATLABArray.MATLAB_Array mATLAB_Array, Class clazz, Map<MWStructInfo, MWStructToBeanFactory> map) {
        Class clazz2 = ArrayUtils.getArrayElementType(clazz);
        ArrayList<Long> arrayList = new ArrayList<Long>(mATLAB_Array.getDimensionList());
        int n = ArrayUtils.getNumberOfDimensions(clazz);
        if (clazz2 == String.class) {
            if (arrayList.contains(0L)) {
                return null;
            }
            if (!ArrayUtils.coerceDimsList(arrayList, n)) {
                throw new RuntimeException(JavaDataExtractor.coersionFailureMsg(mATLAB_Array.getType(), mATLAB_Array.getDimensionList(), String.class, n));
            }
            int[] nArray = ArrayUtils.toIntArray(arrayList.toArray(new Long[arrayList.size()]));
            return JavaDataExtractor.MATLABArrayToJavaCellStrings(mATLAB_Array, nArray);
        }
        if (clazz2 == Object.class) {
            if (arrayList.contains(0L)) {
                return null;
            }
            if (n == 0) {
                n = 1;
            }
            ArrayUtils.coerceDimsList(arrayList, n);
            int[] nArray = ArrayUtils.toIntArray(arrayList.toArray(new Long[arrayList.size()]));
            if (clazz == Object.class && JavaDataExtractor.isCellArrayOfOnlyStrings(mATLAB_Array)) {
                return JavaDataExtractor.MATLABArrayToJavaCellStrings(mATLAB_Array, nArray);
            }
            return this.MATLABArrayToJavaCellObjects(mATLAB_Array, nArray);
        }
        throw new RuntimeException("Data type of output from MATLAB : cell, is unassignable to type of data in Java : " + clazz.getName());
    }

    private static boolean isCellArrayOfOnlyStrings(MATLABArray.MATLAB_Array mATLAB_Array) {
        List<MATLABArray.MATLAB_Array> list = mATLAB_Array.getExtension(MATLABArray.MATLAB_Array.cell).getElementsList();
        for (MATLABArray.MATLAB_Array mATLAB_Array2 : list) {
            if (mATLAB_Array2.getType() == MATLABArray.MATLAB_Array.MWType.CHAR) continue;
            return false;
        }
        return true;
    }

    private static Object MATLABArrayToJavaCellStrings(MATLABArray.MATLAB_Array mATLAB_Array, int[] nArray) {
        List<MATLABArray.MATLAB_Array> list = mATLAB_Array.getExtension(MATLABArray.MATLAB_Array.cell).getElementsList();
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            MATLABArray.MATLAB_Array mATLAB_Array2 = list.get(i);
            MATLABArray.MATLAB_Array.MWType mWType = mATLAB_Array2.getType();
            if (mWType == MATLABArray.MATLAB_Array.MWType.CHAR) {
                ArrayList<Long> arrayList = new ArrayList<Long>(mATLAB_Array2.getDimensionList());
                if (arrayList.contains(0L)) {
                    stringArray[i] = "";
                    continue;
                }
                ArrayUtils.coerceDimsList(arrayList, 0);
                int[] nArray2 = ArrayUtils.toIntArray(arrayList.toArray(new Long[arrayList.size()]));
                stringArray[i] = (String)JavaDataExtractor.MATLABCharArrayToJava(mATLAB_Array2, nArray2, String.class);
                continue;
            }
            throw new RuntimeException("Expecting a cell array containing only strings.\nFound one of the elements in cell array of type :" + mWType.toString());
        }
        if (nArray.length == 0) {
            return stringArray[0];
        }
        return Curler.curl(stringArray, nArray);
    }

    private Object MATLABArrayToJavaCellObjects(MATLABArray.MATLAB_Array mATLAB_Array, int[] nArray) {
        List<MATLABArray.MATLAB_Array> list = mATLAB_Array.getExtension(MATLABArray.MATLAB_Array.cell).getElementsList();
        Object[] objectArray = new Object[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            objectArray[i] = this.toJavaType(list.get(i), Object.class);
        }
        return Curler.curl(objectArray, nArray);
    }

    public static Object MATLABArrayToJavaPrimitives(MATLABArray.MATLAB_Array mATLAB_Array, Class clazz, MATLABArray.MATLAB_Array.MWType mWType) {
        int[] nArray;
        Object object = null;
        String string = mWType.toString().toLowerCase();
        ArrayList<Long> arrayList = new ArrayList<Long>(mATLAB_Array.getDimensionList());
        Class clazz2 = ArrayUtils.getArrayElementType(clazz);
        int n = ArrayUtils.getNumberOfDimensions(clazz);
        if (arrayList.contains(0L)) {
            if (clazz.isPrimitive()) {
                throw new RuntimeException("MATLAB returned data with dimensions : " + arrayList + ".\n" + "This is an empty MATLAB array since one of the dimensions is 0.\n" + "Empty MATLAB arrays are marshaled into Java as null." + "The scalar primitive target type, " + clazz.getName() + ", in Java cannot be assigned null.");
            }
            if (mWType == MATLABArray.MATLAB_Array.MWType.CHAR && clazz == String.class) {
                return "";
            }
            return null;
        }
        if (!JavaDataExtractor.isTargetTypeAssignableFromMATLABType(clazz2, mWType)) {
            throw new RuntimeException("Data type of output from MATLAB : " + string.toLowerCase() + ", is unassignable to type of data in Java : " + clazz2.getName());
        }
        if (clazz2 != Object.class && clazz2 != String.class) {
            if (!ArrayUtils.coerceDimsList(arrayList, n)) {
                throw new RuntimeException(JavaDataExtractor.coersionFailureMsg(mWType, mATLAB_Array.getDimensionList(), clazz2, n));
            }
        } else if (clazz2 == Object.class || clazz == String.class) {
            ArrayUtils.coerceDimsList(arrayList, 0);
        } else {
            throw new RuntimeException("Received MATLAB array of type : " + string + ", with dimensions : " + arrayList + ".\n" + "It cannot be assigned to target of type : " + clazz.getName() + ", in Java.");
        }
        try {
            nArray = ArrayUtils.toIntArray(arrayList.toArray(new Long[arrayList.size()]));
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new RuntimeException(bufferOverflowException);
        }
        switch (mWType) {
            case UINT8: {
                object = JavaDataExtractor.MATLABUint8ArrayToJava(mATLAB_Array, nArray, clazz, clazz2, mWType);
                break;
            }
            case INT8: {
                object = JavaDataExtractor.MATLABInt8ArrayToJava(mATLAB_Array, nArray, clazz, clazz2, mWType);
                break;
            }
            case UINT16: {
                object = JavaDataExtractor.MATLABUint16ArrayToJava(mATLAB_Array, nArray, clazz, clazz2, mWType);
                break;
            }
            case INT16: {
                object = JavaDataExtractor.MATLABInt16ArrayToJava(mATLAB_Array, nArray, clazz, clazz2, mWType);
                break;
            }
            case UINT32: {
                object = JavaDataExtractor.MATLABUint32ArrayToJava(mATLAB_Array, nArray, clazz, clazz2, mWType);
                break;
            }
            case INT32: {
                object = JavaDataExtractor.MATLABInt32ArrayToJava(mATLAB_Array, nArray, clazz, clazz2, mWType);
                break;
            }
            case UINT64: {
                object = JavaDataExtractor.MATLABUint64ArrayToJava(mATLAB_Array, nArray, clazz, clazz2, mWType);
                break;
            }
            case INT64: {
                object = JavaDataExtractor.MATLABInt64ArrayToJava(mATLAB_Array, nArray, clazz, clazz2, mWType);
                break;
            }
            case SINGLE: {
                object = JavaDataExtractor.MATLABSingleArrayToJava(mATLAB_Array, nArray, clazz, clazz2, mWType);
                break;
            }
            case DOUBLE: {
                object = JavaDataExtractor.MATLABDoubleArrayToJava(mATLAB_Array, nArray, clazz, clazz2, mWType);
                break;
            }
            case LOGICAL: {
                object = JavaDataExtractor.MATLABLogicalArrayToJava(mATLAB_Array, nArray, clazz, clazz2, mWType);
                break;
            }
            case CHAR: {
                object = JavaDataExtractor.MATLABCharArrayToJava(mATLAB_Array, nArray, clazz);
            }
        }
        if (clazz2 == Object.class && n > 0) {
            Object[] objectArray = new Object[]{object};
            int[] nArray2 = new int[n];
            Arrays.fill(nArray2, 1);
            return Curler.curl(objectArray, nArray2);
        }
        return object;
    }

    public static Object MATLABUint8ArrayToJava(MATLABArray.MATLAB_Array mATLAB_Array, int[] nArray, Class clazz, Class clazz2, MATLABArray.MATLAB_Array.MWType mWType) {
        MATLABArray.MATLAB_Array.Uint8 uint8 = mATLAB_Array.getExtension(MATLABArray.MATLAB_Array.uint8);
        if (uint8.hasImagElements()) {
            throw new RuntimeException(COMPLEX_DATA_ERR_MSG);
        }
        byte[] byArray = uint8.getElements().toByteArray();
        return JavaDataExtractor.byteArrayToTargetType(byArray, Byte.class, nArray, clazz, clazz2, mWType);
    }

    public static Object MATLABInt8ArrayToJava(MATLABArray.MATLAB_Array mATLAB_Array, int[] nArray, Class clazz, Class clazz2, MATLABArray.MATLAB_Array.MWType mWType) {
        MATLABArray.MATLAB_Array.Int8 int8 = mATLAB_Array.getExtension(MATLABArray.MATLAB_Array.int8);
        if (int8.hasImagElements()) {
            throw new RuntimeException(COMPLEX_DATA_ERR_MSG);
        }
        byte[] byArray = int8.getElements().toByteArray();
        return JavaDataExtractor.byteArrayToTargetType(byArray, Byte.class, nArray, clazz, clazz2, mWType);
    }

    public static Object MATLABUint16ArrayToJava(MATLABArray.MATLAB_Array mATLAB_Array, int[] nArray, Class clazz, Class clazz2, MATLABArray.MATLAB_Array.MWType mWType) {
        MATLABArray.MATLAB_Array.Uint16 uint16 = mATLAB_Array.getExtension(MATLABArray.MATLAB_Array.uint16);
        if (uint16.getImagElementsCount() > 0) {
            throw new RuntimeException(COMPLEX_DATA_ERR_MSG);
        }
        List<Integer> list = uint16.getElementsList();
        List<Short> list2 = ArrayUtils.convertToShortList(list);
        return JavaDataExtractor.toTargetType(list2, Short.class, nArray, clazz, clazz2, mWType);
    }

    public static Object MATLABInt16ArrayToJava(MATLABArray.MATLAB_Array mATLAB_Array, int[] nArray, Class clazz, Class clazz2, MATLABArray.MATLAB_Array.MWType mWType) {
        MATLABArray.MATLAB_Array.Int16 int16 = mATLAB_Array.getExtension(MATLABArray.MATLAB_Array.int16);
        if (int16.getImagElementsCount() > 0) {
            throw new RuntimeException(COMPLEX_DATA_ERR_MSG);
        }
        List<Integer> list = int16.getElementsList();
        List<Short> list2 = ArrayUtils.convertToShortList(list);
        return JavaDataExtractor.toTargetType(list2, Short.class, nArray, clazz, clazz2, mWType);
    }

    public static Object MATLABUint32ArrayToJava(MATLABArray.MATLAB_Array mATLAB_Array, int[] nArray, Class clazz, Class clazz2, MATLABArray.MATLAB_Array.MWType mWType) {
        MATLABArray.MATLAB_Array.Uint32 uint32 = mATLAB_Array.getExtension(MATLABArray.MATLAB_Array.uint32);
        if (uint32.getImagElementsCount() > 0) {
            throw new RuntimeException(COMPLEX_DATA_ERR_MSG);
        }
        List<Integer> list = uint32.getElementsList();
        return JavaDataExtractor.toTargetType(list, Integer.class, nArray, clazz, clazz2, mWType);
    }

    public static Object MATLABInt32ArrayToJava(MATLABArray.MATLAB_Array mATLAB_Array, int[] nArray, Class clazz, Class clazz2, MATLABArray.MATLAB_Array.MWType mWType) {
        MATLABArray.MATLAB_Array.Int32 int32 = mATLAB_Array.getExtension(MATLABArray.MATLAB_Array.int32);
        if (int32.getImagElementsCount() > 0) {
            throw new RuntimeException(COMPLEX_DATA_ERR_MSG);
        }
        List<Integer> list = int32.getElementsList();
        return JavaDataExtractor.toTargetType(list, Integer.class, nArray, clazz, clazz2, mWType);
    }

    public static Object MATLABUint64ArrayToJava(MATLABArray.MATLAB_Array mATLAB_Array, int[] nArray, Class clazz, Class clazz2, MATLABArray.MATLAB_Array.MWType mWType) {
        MATLABArray.MATLAB_Array.Uint64 uint64 = mATLAB_Array.getExtension(MATLABArray.MATLAB_Array.uint64);
        if (uint64.getImagElementsCount() > 0) {
            throw new RuntimeException(COMPLEX_DATA_ERR_MSG);
        }
        List<Long> list = uint64.getElementsList();
        return JavaDataExtractor.toTargetType(list, Long.class, nArray, clazz, clazz2, mWType);
    }

    public static Object MATLABInt64ArrayToJava(MATLABArray.MATLAB_Array mATLAB_Array, int[] nArray, Class clazz, Class clazz2, MATLABArray.MATLAB_Array.MWType mWType) {
        MATLABArray.MATLAB_Array.Int64 int64 = mATLAB_Array.getExtension(MATLABArray.MATLAB_Array.int64);
        if (int64.getImagElementsCount() > 0) {
            throw new RuntimeException(COMPLEX_DATA_ERR_MSG);
        }
        List<Long> list = int64.getElementsList();
        return JavaDataExtractor.toTargetType(list, Long.class, nArray, clazz, clazz2, mWType);
    }

    public static Object MATLABSingleArrayToJava(MATLABArray.MATLAB_Array mATLAB_Array, int[] nArray, Class clazz, Class clazz2, MATLABArray.MATLAB_Array.MWType mWType) {
        MATLABArray.MATLAB_Array.Single single = mATLAB_Array.getExtension(MATLABArray.MATLAB_Array.single);
        if (single.getImagElementsCount() > 0) {
            throw new RuntimeException(COMPLEX_DATA_ERR_MSG);
        }
        List<Float> list = single.getElementsList();
        return JavaDataExtractor.toTargetType(list, Float.class, nArray, clazz, clazz2, mWType);
    }

    public static Object MATLABDoubleArrayToJava(MATLABArray.MATLAB_Array mATLAB_Array, int[] nArray, Class clazz, Class clazz2, MATLABArray.MATLAB_Array.MWType mWType) {
        MATLABArray.MATLAB_Array.Double double_ = mATLAB_Array.getExtension(MATLABArray.MATLAB_Array.mwdouble);
        if (double_.getImagElementsCount() > 0) {
            throw new RuntimeException(COMPLEX_DATA_ERR_MSG);
        }
        List<Double> list = double_.getElementsList();
        return JavaDataExtractor.toTargetType(list, Double.class, nArray, clazz, clazz2, mWType);
    }

    public static Object MATLABLogicalArrayToJava(MATLABArray.MATLAB_Array mATLAB_Array, int[] nArray, Class clazz, Class clazz2, MATLABArray.MATLAB_Array.MWType mWType) {
        List<Boolean> list = mATLAB_Array.getExtension(MATLABArray.MATLAB_Array.logical).getElementsList();
        return JavaDataExtractor.toTargetType(list, Boolean.class, nArray, clazz, clazz2, mWType);
    }

    public static Object MATLABCharArrayToJava(MATLABArray.MATLAB_Array mATLAB_Array, int[] nArray, Class clazz) {
        Object object;
        List<Integer> list = mATLAB_Array.getExtension(MATLABArray.MATLAB_Array.mwchar).getElementsList();
        Integer[] integerArray = list.toArray(new Integer[list.size()]);
        char[] cArray = ArrayUtils.toCharArray(integerArray);
        if (clazz == String.class) {
            if (nArray.length > 1) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length);
                for (int n : nArray) {
                    arrayList.add(n);
                }
                throw new RuntimeException("Failure to assign char array of size, " + arrayList + ", received from MATLAB to an instance of java.lang.String.");
            }
            object = new String(cArray);
        } else {
            Class clazz2 = ArrayUtils.getArrayElementType(clazz);
            if (nArray.length == 0) {
                return Character.valueOf(cArray[0]);
            }
            if (clazz2 == Object.class && nArray.length == 1) {
                return new String(cArray);
            }
            object = clazz2 == Character.class ? Curler.curl((Object[])ArrayUtils.toCharacterArray(integerArray), nArray) : Curler.curl(cArray, nArray);
        }
        return object;
    }

    private Object[] convertStructToBeanArray(MATLABArray.MATLAB_Array mATLAB_Array, Map<MWStructInfo, MWStructToBeanFactory> map) {
        MATLABArray.MATLAB_Array.Struct struct = mATLAB_Array.getExtension(MATLABArray.MATLAB_Array.struct);
        List<String> list = struct.getFieldNamesList();
        MWStructInfo mWStructInfo = new MWStructInfo(list);
        MWStructToBeanFactory mWStructToBeanFactory = map.get(new MWStructInfo(list));
        if (mWStructToBeanFactory == null) {
            throw new RuntimeException("No user defined JAVA type available for a MATLAB structure with fields : " + list);
        }
        List<MATLABArray.MATLAB_Array> list2 = struct.getElementsList();
        int n = list.size();
        int n2 = n == 0 ? 0 : list2.size() / n;
        Object[] objectArray = (Object[])Array.newInstance(mWStructToBeanFactory.getBeanType(), n2);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            Object[] objectArray2 = new Object[n];
            for (int j = 0; j < n; ++j) {
                String string = list.get(j);
                MATLABArray.MATLAB_Array mATLAB_Array2 = list2.get(n3++);
                try {
                    objectArray2[j] = this.getmlArray(mATLAB_Array2, mWStructToBeanFactory.getJavaClassForStructField(string), mWStructToBeanFactory.getBeanType());
                    continue;
                }
                catch (Exception exception) {
                    String string2 = mWStructToBeanFactory.getBeanType().getName();
                    String string3 = mWStructToBeanFactory.getJavaClassForStructField(string).getName();
                    String string4 = "Trouble marshaling a MATLAB structure with fields : " + list + ",\n" + "into a user defined Java class : " + string2 + ".\n" + "Property, " + string + ", of class, " + string2 + ", has a declared type of : " + string3 + ",\n" + "but was assigned a value of MATLAB type : " + mATLAB_Array2.getType().toString().toLowerCase() + ".\n" + "Please refer the javadoc for more information on automatic type conversion.";
                    throw new RuntimeException(string4, exception);
                }
            }
            objectArray[i] = mWStructToBeanFactory.newInstance(list, objectArray2);
        }
        return objectArray;
    }

    private static <T> Object toTargetType(List<T> list, Class<T> clazz, int[] nArray, Class clazz2, Class clazz3, MATLABArray.MATLAB_Array.MWType mWType) {
        if (nArray.length == 0) {
            if (!JavaDataExtractor.canBeCoerced(clazz3, mWType)) {
                return list.get(0);
            }
            return JavaDataExtractor.convertScalarType(clazz3, list.get(0));
        }
        Object[] objectArray = ArrayUtils.convertToArray(list, clazz);
        if (JavaDataExtractor.canBeCoerced(clazz3, mWType)) {
            Object object = JavaDataExtractor.convertArrayType(clazz2, clazz3, objectArray, nArray);
            return JavaDataExtractor.curlArray(object, clazz3, nArray);
        }
        if (clazz3.equals(Object.class) || clazz3.isPrimitive()) {
            Class clazz4 = ArrayUtils.unBoxIfBoxedType(clazz);
            Object object = ArrayUtils.toPrimitiveArray(objectArray, clazz4);
            return JavaDataExtractor.curlArray(object, clazz4, nArray);
        }
        return Curler.curl(objectArray, nArray);
    }

    private static Object byteArrayToTargetType(byte[] byArray, Class clazz, int[] nArray, Class clazz2, Class clazz3, MATLABArray.MATLAB_Array.MWType mWType) {
        if (nArray.length == 0) {
            if (!JavaDataExtractor.canBeCoerced(clazz3, mWType)) {
                return byArray[0];
            }
            return JavaDataExtractor.convertScalarType(clazz3, byArray[0]);
        }
        if (JavaDataExtractor.canBeCoerced(clazz3, mWType)) {
            Byte[] byteArray = ArrayUtils.toBoxedArray(byArray);
            Object object = JavaDataExtractor.convertArrayType(clazz2, clazz3, byteArray, nArray);
            return JavaDataExtractor.curlArray(object, clazz3, nArray);
        }
        if (clazz3.equals(Object.class) || clazz3.isPrimitive()) {
            return Curler.curl(byArray, nArray);
        }
        Object[] objectArray = ArrayUtils.toBoxedArray(byArray);
        return Curler.curl(objectArray, nArray);
    }

    private static Object curlArray(Object object, Class clazz, int[] nArray) {
        try {
            Method method = Curler.class.getMethod("curl", primitiveToArrayType.get(clazz), int[].class);
            return method.invoke(null, object, nArray);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failure to coerce a MATLAB array to Java type :", exception);
        }
    }

    private static boolean isTargetTypeAssignableFromMATLABType(Class clazz, MATLABArray.MATLAB_Array.MWType mWType) {
        return directlyConvertibleTypesMap.get(mWType).contains(clazz) || scalarCoercibleNumericTypesMap.containsKey(mWType) && scalarCoercibleNumericTypesMap.get(mWType).contains(clazz);
    }

    private static boolean canBeCoerced(Class clazz, MATLABArray.MATLAB_Array.MWType mWType) {
        return scalarCoercibleNumericTypesMap.containsKey(mWType) && scalarCoercibleNumericTypesMap.get(mWType).contains(clazz);
    }

    private static Object convertScalarType(Class clazz, Object object) {
        try {
            return targetTypeToScalarCoercionMethod.get(clazz).invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failure to coerce a scalar MATLAB value to Java type : " + clazz);
        }
    }

    private static Object convertArrayType(Class clazz, Class clazz2, Object object, int[] nArray) {
        try {
            return targetTypeToArrayCoercionMethod.get(clazz2).invoke(null, object);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failure to coerce a MATLAB array of Type to Java type : " + clazz, exception);
        }
    }

    static {
        directlyConvertibleTypesMap = new HashMap<MATLABArray.MATLAB_Array.MWType, List>();
        directlyConvertibleTypesMap.put(MATLABArray.MATLAB_Array.MWType.UINT8, Arrays.asList(Object.class, Byte.TYPE, Byte.class));
        directlyConvertibleTypesMap.put(MATLABArray.MATLAB_Array.MWType.INT8, Arrays.asList(Object.class, Byte.TYPE, Byte.class));
        directlyConvertibleTypesMap.put(MATLABArray.MATLAB_Array.MWType.UINT16, Arrays.asList(Object.class, Short.TYPE, Short.class));
        directlyConvertibleTypesMap.put(MATLABArray.MATLAB_Array.MWType.INT16, Arrays.asList(Object.class, Short.TYPE, Short.class));
        directlyConvertibleTypesMap.put(MATLABArray.MATLAB_Array.MWType.INT32, Arrays.asList(Object.class, Integer.TYPE, Integer.class));
        directlyConvertibleTypesMap.put(MATLABArray.MATLAB_Array.MWType.UINT32, Arrays.asList(Object.class, Integer.TYPE, Integer.class));
        directlyConvertibleTypesMap.put(MATLABArray.MATLAB_Array.MWType.INT64, Arrays.asList(Object.class, Long.TYPE, Long.class));
        directlyConvertibleTypesMap.put(MATLABArray.MATLAB_Array.MWType.UINT64, Arrays.asList(Object.class, Long.TYPE, Long.class));
        directlyConvertibleTypesMap.put(MATLABArray.MATLAB_Array.MWType.SINGLE, Arrays.asList(Object.class, Float.TYPE, Float.class));
        directlyConvertibleTypesMap.put(MATLABArray.MATLAB_Array.MWType.DOUBLE, Arrays.asList(Object.class, Double.TYPE, Double.class));
        directlyConvertibleTypesMap.put(MATLABArray.MATLAB_Array.MWType.LOGICAL, Arrays.asList(Object.class, Boolean.TYPE, Boolean.class));
        directlyConvertibleTypesMap.put(MATLABArray.MATLAB_Array.MWType.CHAR, Arrays.asList(Object.class, Character.TYPE, Character.class, String.class));
        directlyConvertibleTypesMap.put(MATLABArray.MATLAB_Array.MWType.CELL, Arrays.asList(Object.class, String.class));
        scalarCoercibleNumericTypesMap = new HashMap<MATLABArray.MATLAB_Array.MWType, List>();
        scalarCoercibleNumericTypesMap.put(MATLABArray.MATLAB_Array.MWType.UINT8, Arrays.asList(Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE));
        scalarCoercibleNumericTypesMap.put(MATLABArray.MATLAB_Array.MWType.INT8, Arrays.asList(Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE));
        scalarCoercibleNumericTypesMap.put(MATLABArray.MATLAB_Array.MWType.UINT16, Arrays.asList(Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE));
        scalarCoercibleNumericTypesMap.put(MATLABArray.MATLAB_Array.MWType.INT16, Arrays.asList(Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE));
        scalarCoercibleNumericTypesMap.put(MATLABArray.MATLAB_Array.MWType.INT32, Arrays.asList(Long.TYPE, Float.TYPE, Double.TYPE));
        scalarCoercibleNumericTypesMap.put(MATLABArray.MATLAB_Array.MWType.UINT32, Arrays.asList(Long.TYPE, Float.TYPE, Double.TYPE));
        scalarCoercibleNumericTypesMap.put(MATLABArray.MATLAB_Array.MWType.INT64, Arrays.asList(Float.TYPE, Double.TYPE));
        scalarCoercibleNumericTypesMap.put(MATLABArray.MATLAB_Array.MWType.UINT64, Arrays.asList(Float.TYPE, Double.TYPE));
        scalarCoercibleNumericTypesMap.put(MATLABArray.MATLAB_Array.MWType.SINGLE, Arrays.asList(Double.TYPE));
        scalarCoercibleNumericTypesMap.put(MATLABArray.MATLAB_Array.MWType.DOUBLE, Arrays.asList(Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE));
        targetTypeToScalarCoercionMethod = new HashMap<Class, Method>();
        try {
            targetTypeToScalarCoercionMethod.put(Byte.TYPE, Number.class.getMethod("byteValue", new Class[0]));
            targetTypeToScalarCoercionMethod.put(Short.TYPE, Number.class.getMethod("shortValue", new Class[0]));
            targetTypeToScalarCoercionMethod.put(Integer.TYPE, Number.class.getMethod("intValue", new Class[0]));
            targetTypeToScalarCoercionMethod.put(Long.TYPE, Number.class.getMethod("longValue", new Class[0]));
            targetTypeToScalarCoercionMethod.put(Float.TYPE, Number.class.getMethod("floatValue", new Class[0]));
            targetTypeToScalarCoercionMethod.put(Double.TYPE, Number.class.getMethod("doubleValue", new Class[0]));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
        targetTypeToArrayCoercionMethod = new HashMap<Class, Method>();
        targetTypeToArrayCoercionMethod.put(Byte.TYPE, ArrayNumericCoercionEnabler.toByteArray);
        targetTypeToArrayCoercionMethod.put(Double.TYPE, ArrayNumericCoercionEnabler.toDoubleArray);
        targetTypeToArrayCoercionMethod.put(Float.TYPE, ArrayNumericCoercionEnabler.toFloatArray);
        targetTypeToArrayCoercionMethod.put(Integer.TYPE, ArrayNumericCoercionEnabler.toIntegerArray);
        targetTypeToArrayCoercionMethod.put(Long.TYPE, ArrayNumericCoercionEnabler.toLongArray);
        targetTypeToArrayCoercionMethod.put(Short.TYPE, ArrayNumericCoercionEnabler.toShortArray);
        primitiveToArrayType = new HashMap<Class, Class>();
        primitiveToArrayType.put(Byte.TYPE, byte[].class);
        primitiveToArrayType.put(Double.TYPE, double[].class);
        primitiveToArrayType.put(Float.TYPE, float[].class);
        primitiveToArrayType.put(Integer.TYPE, int[].class);
        primitiveToArrayType.put(Long.TYPE, long[].class);
        primitiveToArrayType.put(Short.TYPE, short[].class);
        primitiveToArrayType.put(Boolean.TYPE, boolean[].class);
    }
}

