/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal;

import com.mathworks.mps.client.MWMarshalingRules;
import com.mathworks.mps.client.annotations.MWStructureList;
import com.mathworks.mps.client.internal.ArrayUtils;
import com.mathworks.mps.client.internal.MWStructInfo;
import com.mathworks.mps.client.internal.MWStructToBeanFactory;
import com.mathworks.mps.client.internal.MWStructToBeanFactoryConstructor;
import com.mathworks.mps.client.internal.MWStructToBeanFactoryMaker;
import com.mathworks.mps.client.internal.MWStructToBeanFactorySetter;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MWAttributesContainer {
    private final List<Class> mwStructList;
    private final Map<Class, Map<Class, Map<String, Method>>> mlInputStructCache = new HashMap<Class, Map<Class, Map<String, Method>>>();
    private final Map<Class, Map<MWStructInfo, MWStructToBeanFactory>> mlOutputStructCache = new HashMap<Class, Map<MWStructInfo, MWStructToBeanFactory>>();

    public MWAttributesContainer(MWMarshalingRules mWMarshalingRules) {
        this.mwStructList = Collections.unmodifiableList(mWMarshalingRules.getStructTypes());
        this.updateMLInputStructCache();
        this.analyzeCircularDependencyForInputs();
        this.updateMLOutputStructCache();
        this.analyzeCircularDependencyForOutputs();
    }

    public Map<Class, Map<String, Method>> getChildrenStructsForParentMLInput(Class clazz) {
        return this.mlInputStructCache.get(clazz);
    }

    public Map<MWStructInfo, MWStructToBeanFactory> getChildrenStructsForParentMLOutput(Class clazz) {
        return this.mlOutputStructCache.get(clazz);
    }

    private void analyzeCircularDependencyForOutputs() {
        Set<MWStructInfo> set = this.mlOutputStructCache.get(Method.class).keySet();
        for (MWStructInfo mWStructInfo : set) {
            ArrayList<Class> arrayList = new ArrayList<Class>();
            Class clazz = mWStructInfo.getBeanType();
            if (clazz == null) continue;
            arrayList.add(clazz);
            this.analyzeCircularDependencyForOutputs(this.mlOutputStructCache.get(clazz), arrayList);
        }
    }

    private void analyzeCircularDependencyForOutputs(Map<MWStructInfo, MWStructToBeanFactory> map, List<Class> list) {
        Set<MWStructInfo> set = map.keySet();
        for (MWStructInfo mWStructInfo : set) {
            Class clazz = mWStructInfo.getBeanType();
            if (clazz == null) continue;
            if (!list.contains(clazz)) {
                list.add(clazz);
                this.analyzeCircularDependencyForOutputs(this.mlOutputStructCache.get(clazz), list);
                continue;
            }
            throw new IllegalArgumentException(this.getCircularDependencyExceptionText(clazz));
        }
    }

    private void analyzeCircularDependencyForInputs() {
        Set<Class> set = this.mlInputStructCache.get(Method.class).keySet();
        for (Class clazz : set) {
            ArrayList<Class> arrayList = new ArrayList<Class>();
            arrayList.add(clazz);
            this.analyzeCircularDependencyForInputs(this.mlInputStructCache.get(clazz), arrayList);
        }
    }

    private void analyzeCircularDependencyForInputs(Map<Class, Map<String, Method>> map, List<Class> list) {
        Set<Class> set = map.keySet();
        for (Class clazz : set) {
            if (!list.contains(clazz)) {
                list.add(clazz);
                this.analyzeCircularDependencyForInputs(this.mlInputStructCache.get(clazz), list);
                continue;
            }
            throw new IllegalArgumentException(this.getCircularDependencyExceptionText(clazz));
        }
    }

    private void updateMLOutputStructCache() {
        this.mlOutputStructCache.put(Method.class, new HashMap());
        for (Class clazz : this.mwStructList) {
            this.updateMLOutputStructCache(Method.class, clazz);
        }
    }

    private void updateMLOutputStructCache(Class clazz, Class clazz2) {
        Class clazz3 = ArrayUtils.getArrayElementType(clazz2);
        if (!(clazz3.isPrimitive() || clazz3.equals(String.class) || clazz3.equals(Object.class))) {
            if (clazz.equals(clazz3)) {
                throw new IllegalArgumentException("While analyzing user defined types for MATLAB output struct, a circular dependency was detected for Java type : " + clazz.getName() + ".");
            }
            Map<MWStructInfo, MWStructToBeanFactory> map = this.mlOutputStructCache.get(clazz);
            List<MWStructToBeanFactory> list = MWStructToBeanFactoryMaker.createFactoryList(clazz3);
            if (list.size() > 0) {
                int n = 0;
                for (MWStructToBeanFactory object : list) {
                    MWStructInfo mWStructInfo = new MWStructInfo(object.getPropNames());
                    if (n == 0) {
                        mWStructInfo.setBeanType(clazz3);
                    }
                    if (map.containsKey(mWStructInfo)) continue;
                    map.put(mWStructInfo, object);
                    ++n;
                }
                if (!this.mlOutputStructCache.containsKey(clazz3)) {
                    this.mlOutputStructCache.put(clazz3, new HashMap());
                    MWStructureList mWStructureList = clazz3.getAnnotation(MWStructureList.class);
                    if (mWStructureList != null) {
                        Class[] classArray;
                        for (Class[] classArray2 : classArray = mWStructureList.value()) {
                            this.updateMLOutputStructCache(clazz3, (Class)classArray2);
                        }
                    }
                    for (MWStructToBeanFactory mWStructToBeanFactory : list) {
                        Constructor constructor;
                        MWStructureList mWStructureList2;
                        Class[] classArray2;
                        if (mWStructToBeanFactory instanceof MWStructToBeanFactorySetter) {
                            Map<String, Method> map2 = ((MWStructToBeanFactorySetter)mWStructToBeanFactory).getBeanSetterMap();
                            Collection<Method> collection = map2.values();
                            classArray2 = collection.iterator();
                            while (classArray2.hasNext()) {
                                Class[] classArray;
                                Class[] classArray3 = (Class[])classArray2.next();
                                MWStructureList mWStructureList3 = classArray3.getAnnotation(MWStructureList.class);
                                if (mWStructureList3 == null) continue;
                                for (Class clazz4 : classArray = mWStructureList3.value()) {
                                    this.updateMLOutputStructCache(clazz3, clazz4);
                                }
                            }
                            continue;
                        }
                        if (!(mWStructToBeanFactory instanceof MWStructToBeanFactoryConstructor) || (mWStructureList2 = (constructor = ((MWStructToBeanFactoryConstructor)mWStructToBeanFactory).getBeanConstructor()).getAnnotation(MWStructureList.class)) == null) continue;
                        for (Class clazz5 : classArray2 = mWStructureList2.value()) {
                            this.updateMLOutputStructCache(clazz3, clazz5);
                        }
                    }
                }
            }
        }
    }

    private void updateMLInputStructCache() {
        this.mlInputStructCache.put(Method.class, new HashMap());
        for (Class clazz : this.mwStructList) {
            this.updateMLInputStructCache(Method.class, clazz);
        }
    }

    private void updateMLInputStructCache(Class clazz, Class clazz2) {
        Class clazz3 = ArrayUtils.getArrayElementType(clazz2);
        if (!(clazz3.isPrimitive() || clazz3.equals(String.class) || clazz3.equals(Object.class))) {
            List<PropertyDescriptor> list;
            if (clazz.equals(clazz3)) {
                throw new IllegalArgumentException("While analyzing user defined types for MATLAB input struct, a circular dependency was detected for Java type : " + clazz.getName() + ".");
            }
            Map<Class, Map<String, Method>> map = this.mlInputStructCache.get(clazz);
            if (!map.containsKey(clazz3) && (list = this.getPropertyDescriptorsWithGetters(clazz3)).size() > 0) {
                HashMap<String, Method> hashMap = new HashMap<String, Method>();
                for (PropertyDescriptor object : list) {
                    hashMap.put(object.getDisplayName(), object.getReadMethod());
                }
                map.put(clazz3, hashMap);
                if (!this.mlInputStructCache.containsKey(clazz3)) {
                    this.mlInputStructCache.put(clazz3, new HashMap());
                    MWStructureList mWStructureList = clazz3.getAnnotation(MWStructureList.class);
                    if (mWStructureList != null) {
                        Class[] classArray;
                        for (Class[] classArray2 : classArray = mWStructureList.value()) {
                            this.updateMLInputStructCache(clazz3, (Class)classArray2);
                        }
                    }
                    for (PropertyDescriptor propertyDescriptor : list) {
                        Class[] classArray;
                        MWStructureList mWStructureList2 = propertyDescriptor.getReadMethod().getAnnotation(MWStructureList.class);
                        if (mWStructureList2 == null) continue;
                        for (Class clazz4 : classArray = mWStructureList2.value()) {
                            this.updateMLInputStructCache(clazz3, clazz4);
                        }
                    }
                }
            }
        }
    }

    private List<PropertyDescriptor> getPropertyDescriptorsWithGetters(Class clazz) {
        ArrayList<PropertyDescriptor> arrayList = new ArrayList<PropertyDescriptor>();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz, Object.class);
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            if (propertyDescriptorArray != null && propertyDescriptorArray.length > 0) {
                for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray) {
                    if (propertyDescriptor.getReadMethod() == null) continue;
                    arrayList.add(propertyDescriptor);
                }
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        return arrayList;
    }

    private String getCircularDependencyExceptionText(Class clazz) {
        return "While analyzing Java type as a possible MATLAB struct convertible type, a circular dependency was detected for : " + clazz.getName();
    }
}

