/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mps.client.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class MWSSLContext {
    private static Method defaultSSLContextMethod = null;

    public static SSLContext getDefault() throws GeneralSecurityException, IllegalAccessException, IOException, PrivilegedActionException {
        if (defaultSSLContextMethod != null) {
            try {
                return (SSLContext)defaultSSLContextMethod.invoke(null, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable instanceof NoSuchAlgorithmException) {
                    throw (NoSuchAlgorithmException)throwable;
                }
                throw (RuntimeException)throwable;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw illegalAccessException;
            }
        }
        SSLContext sSLContext = SSLContext.getInstance("ssl");
        sSLContext.init(MWSSLContext.getDefaultKeyManager(), MWSSLContext.getDefaultTrustManager(), null);
        return sSLContext;
    }

    private static TrustManager[] getDefaultTrustManager() throws GeneralSecurityException, IOException, PrivilegedActionException {
        KeyStore keyStore = MWSSLContext.getCacertsKeyStore();
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        return trustManagerFactory.getTrustManagers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore getCacertsKeyStore() throws GeneralSecurityException, IOException, PrivilegedActionException {
        final HashMap hashMap = new HashMap();
        AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                hashMap.put("trustStore", System.getProperty("javax.net.ssl.trustStore"));
                hashMap.put("javaHome", System.getProperty("java.home"));
                hashMap.put("trustStoreType", System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType()));
                hashMap.put("trustStoreProvider", System.getProperty("javax.net.ssl.trustStoreProvider", ""));
                hashMap.put("trustStorePasswd", System.getProperty("javax.net.ssl.trustStorePassword", ""));
                return null;
            }
        });
        String string = (String)hashMap.get("trustStore");
        FileInputStream fileInputStream = null;
        KeyStore keyStore = null;
        try {
            String string2;
            if (!"NONE".equals(string)) {
                File file;
                if (string != null) {
                    file = new File(string);
                    fileInputStream = MWSSLContext.getFileInputStream(file);
                } else {
                    string2 = (String)hashMap.get("javaHome");
                    file = MWSSLContext.fullfile(string2, "lib", "security", "jssecacerts");
                    fileInputStream = MWSSLContext.getFileInputStream(file);
                    if (fileInputStream == null) {
                        file = MWSSLContext.fullfile(string2, "lib", "security", "cacerts");
                        fileInputStream = MWSSLContext.getFileInputStream(file);
                    }
                }
            }
            string2 = (String)hashMap.get("trustStoreType");
            String string3 = (String)hashMap.get("trustStoreProvider");
            if (string2.length() != 0) {
                keyStore = string3.length() == 0 ? KeyStore.getInstance(string2) : KeyStore.getInstance(string2, string3);
                char[] cArray = null;
                String string4 = (String)hashMap.get("trustStorePasswd");
                if (string4.length() != 0) {
                    cArray = string4.toCharArray();
                }
                keyStore.load(fileInputStream, cArray);
                if (cArray != null) {
                    for (int i = 0; i < cArray.length; ++i) {
                        cArray[i] = '\u0000';
                    }
                }
            }
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        return keyStore;
    }

    private static FileInputStream getFileInputStream(final File file) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

            @Override
            public FileInputStream run() throws Exception {
                try {
                    if (file.exists()) {
                        return new FileInputStream(file);
                    }
                    return null;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return null;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyManager[] getDefaultKeyManager() throws GeneralSecurityException, IOException, PrivilegedActionException {
        Object object;
        final HashMap hashMap = new HashMap();
        AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                hashMap.put("keyStore", System.getProperty("javax.net.ssl.keyStore", ""));
                hashMap.put("keyStoreType", System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType()));
                hashMap.put("keyStoreProvider", System.getProperty("javax.net.ssl.keyStoreProvider", ""));
                hashMap.put("keyStorePasswd", System.getProperty("javax.net.ssl.keyStorePassword", ""));
                return null;
            }
        });
        final String string = (String)hashMap.get("keyStore");
        String string2 = (String)hashMap.get("keyStoreType");
        String string3 = (String)hashMap.get("keyStoreProvider");
        if ("PKCS11".equals(string2) && !"NONE".equals(string)) {
            throw new IllegalArgumentException("if keyStoreType is PKCS11, then keyStore must be NONE");
        }
        FileInputStream fileInputStream = null;
        KeyStore keyStore = null;
        char[] cArray = null;
        try {
            if (string.length() != 0 && !"NONE".equals(string)) {
                fileInputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                    @Override
                    public FileInputStream run() throws Exception {
                        return new FileInputStream(string);
                    }
                });
            }
            if (((String)(object = (String)hashMap.get("keyStorePasswd"))).length() != 0) {
                cArray = ((String)object).toCharArray();
            }
            if (string2.length() != 0) {
                keyStore = string3.length() == 0 ? KeyStore.getInstance(string2) : KeyStore.getInstance(string2, string3);
                keyStore.load(fileInputStream, cArray);
            }
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        object = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        if ("PKCS11".equals(string2)) {
            ((KeyManagerFactory)object).init(keyStore, null);
        } else {
            ((KeyManagerFactory)object).init(keyStore, cArray);
        }
        KeyManager[] keyManagerArray = ((KeyManagerFactory)object).getKeyManagers();
        return keyManagerArray;
    }

    private static File fullfile(String ... stringArray) {
        File file = null;
        for (String string : stringArray) {
            file = null == file ? new File(string) : new File(file, string);
        }
        return file;
    }

    static {
        try {
            defaultSSLContextMethod = SSLContext.class.getMethod("getDefault", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

